# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe SquareRootArithmetic do

    subject { SquareRootArithmetic.new }

    [
      ['(sqrt(13) + sqrt(17))^2 + sqrt(25)', '2 * sqrt(221) + 35'],
      ['(sqrt(18) - 7 * sqrt(19)) * -(3 * sqrt(7) + 9 * sqrt(7))', '84 * sqrt(133) - 36 * sqrt(14)'],
      ['(2 * sqrt(2) - sqrt(9))^2 * 8', '136-96*sqrt(2)'],
      ['sqrt(24) * (8 * sqrt(30) - sqrt(3))^2', '641 * 6^(3 / 2) - 192 * sqrt(15)'],
      ['(3 * sqrt(4) - 4 * sqrt(2))^2 / (sqrt(10) - sqrt(8))', '68 / (sqrt(10) - 2 * sqrt(2)) - 8 * (3 * 2^(3 / 2)) / (sqrt(10) - 2 * sqrt(2))'],
      ['9^2 / 2 * sqrt(19)^2', '1539/2'],
      ['sqrt(3) * sqrt(5)', 'sqrt(15)'],

    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

