# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe OrdinaryArithmetic do

    subject { OrdinaryArithmetic.new }

    [
      ['-92.92 - (-0.45)', '-92.47'],
      ['91 - (-43)',       '134'],
    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

