# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe FractionalArithmetic do

    subject { FractionalArithmetic.new }

    [
      ['-70/71 div 84/50', '-125/213'],
      ['25/66 * 60/93', '250/1023'],
      ['-86/62 * (-76/51)', '3268/1581'],
      ['-90/54 - (-9/91)', '-428/273'],
    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

