# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe ComplexFractionalArithmetic do

    subject { ComplexFractionalArithmetic.new }

    [
      ['6/8 / (9/1 * 9/6)', '1 / 18'],
      ['7/5 / (2/8 - 8/9)', '-252/115'],
      ['4/8 - 2/7 / (5/9 - 6/7)', '55/38'],
      ['1/9 + 7/8 / (7/8 * 3/7)', '22/9'],

    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

