# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Generator
  describe OrdinaryArithmetic do

    subject{ OrdinaryArithmetic.new }

    before(:all) { @opt_pattern = %r! [+\-*]|div ! }

    it_should_behave_like 'Arithmetic'

    it do
      subject.should_receive(:create_integer)
      subject.__send__(:operand)
    end

    context 'create expression' do
      (1..100).to_a.shuffle[1, 10].each do |n|
        context n do
          before(:all) do
            # MEMO: it calls last_operator in integer without arguments
            $stderr, @orig_error = StringIO.new, $stderr
            subject.should_receive(:last_operand).exactly(n).times {|o| o }
            subject.should_receive(:last_operator).exactly(n*2).times {|o| o }
          end
          after(:all) { $stderr = @orig_error }
          before do
            @problems = subject.generate(:term_number => n)
          end
          it { @problems.should have(1).problem }
          it { @problems.first.split(@opt_pattern).should have(n).operands }
          it { @problems.first.scan(@opt_pattern).should have(n-1).operators }
        end
      end
    end
  end
end

