# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint
  describe Generator::FractionalExpressionArithmetic do

    subject{ Generator::FractionalExpressionArithmetic.new }
    before(:all) { @opt_pattern = %r! (?:[+\-*]|div) ! }

    it_should_behave_like 'Arithmetic'

    it do
      subject.should_receive(:fraction)
      subject.__send__(:operand)
    end

    describe '2 terms' do


      context 'create expression' do

        context '0/1' do
          before do
            settings = {
              :x => ['x', 'y', 'z'],
              :numerator_term_min => 0,
              :numerator_term_max => 0,
            }
            @pattern = %r!\d+\/\(([xyz]) [+-] \d+\) (?:[+*-]|div) \d+\/\(\1 [+-] \d+\)!
            @problems = subject.generate(settings)
          end
          it{ @problems.should have(1).problem }
          it{ @problems.first.split(/\//).should have(3).terms }
          it{ @problems.first.should match(@pattern) }
        end

        before do
          variables = %w[ A B C ]
          @defaults = { :x => variables }
          @term = "\\([#{variables}]\ [+-]\ \\d+\\)"
        end

        ([1] + (2..100).to_a.shuffle[0, 9]).combination(2) do |i, j|
          context "#{i}/#{j}" do
            before do
              num = ''
              num << '\(' unless i == 1
              num << @term * i
              num << '\)' unless i == 1
              den = ''
              den << '\(' unless j == 1
              den << @term * j
              den << '\)' unless j == 1
              part = "#{num}\\/#{den}"
              @pattern = %r!#{part}#{@opt_pattern}#{part}!
              settings = {
                :numerator_term_min => i,
                :numerator_term_max => i,
                :denominator_term_min => j,
                :denominator_term_max => j,
              }
              @problems = subject.generate(@defaults.merge(settings))
            end
            it{ @problems.should have(1).problem }
            it{ @problems.first.split(/\//).should have(3).terms }
            it{ @problems.first.scan(/#{@opt_pattern}/).should have((i + j) * 2 + 1).terms }
            it{ @problems.first.should match(@pattern) }
          end
        end
      end
    end

    context 'term number' do
      (1..100).to_a.shuffle[0, 10].each do |n|
        context n do
          before { @problems = subject.generate(:term_number => n) }
          it { @problems.first.split(/\//).should have(n+1).terms }
        end
      end
    end
  end
end
