# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb' 
module Mint::Generator

  describe Factorization do

    subject { Factorization.new }

    it_should_behave_like 'HighOrderExpression'

    context 'order 2' do

      context 'easy' do
        before do
          options = {
            :order_min => 2, :order_max => 2, :x => ['x', 'y', 'z'],
            :factor_min => 1, :factor_max => 10
          }
          @problems = subject.generate(options)
        end
        it{ @problems.should have(1).problem }
        it{ @problems.first.split(%r! [+-] !).should have_at_most(3).terms }
        it{ @problems.first.should match(%r![xyz]\^2 [+-] (?:\d+)?[xyz] [+-] \d+!) }
      end

      context 'normal' do
        before do
          options = {
            :order_min => 2, :order_max => 2, :x => ['x'],
            :factor_min => 1, :factor_max => 5,
            :use_coefficient => true
          }
          @solver = Mint::Solver::Maxima::Factory.create(:factorization)
          @problems = subject.generate(options)
        end
        it{ @problems.should have(1).problem }
        it{ @problems.first.split(%r! [+-] !).should have_at_most(3).terms }
        it{ @problems.first.should match(%r!(?:\d+)[xyz]\^2 [+-] (?:\d+)?[xyz] [+-] \d+!) }
        it{ expect { @solver.solve(Mint::Builder.build(@problems.first)) }.to_not raise_error }
      end
    end
    context 'order 2 when factor may be 0' do
      subject{ Factorization.new(10) }
      before do
        options = {
          :order_min => 2, :order_max => 2,
          :factor_min => 0, :factor_max => 10
        }
        @problems = subject.generate(options)
      end
      it{ @problems.should have(10).problem }
      it "have 3 terms at most" do
        @problems.each do |problem|
          problem.split(%r! [+-] !).should have_at_most(3).terms
        end
      end
      it "have 2 terms at least" do
        @problems.each do |problem|
          problem.split(%r! [+-] !).should have_at_least(2).terms
        end
      end
      it "match format" do
        @problems.each do |problem|
          problem.should match(%r!(?:(?:\d+)?x\^2)?(?: [+-] (?:\d+)?x)?(?: [+-] \d+)?!)
        end
      end
      it "does not match '1x'" do
        @problems.each do |problem|
          problem.should_not match(%r!\A1x|[ -]1x!)
        end
      end
    end
    context 'order 3' do


      context 'easy' do

        subject { Factorization.new }

        before do
          options = {
            :order_min => 3, :order_max => 3,
            :factor_min => 1, :factor_max => 10
          }
          @problems = subject.generate(options)
        end
        it{ @problems.should have(1).problem }
        it{ @problems.first.split(%r! [+-] !).should have_at_most(4).terms }
        it{ @problems.first.should match(%r!x\^3 [+-] (?:\d+)?x\^2 [+-] (?:\d+)?x [+-] \d+!) }
        it{ @problems.first.should_not match(%r!\A1x|[ -]1x!) }
      end

      context 'normal' do

        subject { Factorization.new }

        before do
          options = {
            :order_min => 3, :order_max => 3,
            :factor_min => 1, :factor_max =>5,
            :use_coefficient => true
          }
          @solver = Mint::Solver::Maxima::Factory.create(:factorization)
          @problems = subject.generate(options)
        end
        it{ @problems.should have(1).problem }
        it{ @problems.first.split(%r! [+-] !).should have_at_most(4).terms }
        it{ @problems.first.should match(%r!(?:\d+)x\^3 [+-] (?:\d+)?x\^2 [+-] (?:\d+)?x [+-] \d+!) }
        it{ @problems.first.should_not match(%r!\A1x|[ -]1x!) }
        it{ expect { @solver.solve(Mint::Builder.build(@problems.first)) }.to_not raise_error}
      end
    end
  end
end

