# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Generator
  describe DecimalArithmetic do

    subject{ DecimalArithmetic.new }

    before(:all) { @opt_pattern = %r! [+\-*]|div ! }

    it_should_behave_like 'Arithmetic'

    it do
      subject.should_receive(:decimal)
      subject.__send__(:operand)
    end

    context 'create expression' do
      (1..100).to_a.shuffle[1, 10].each do |n|
        context n do
          before(:all) do
            subject.should_receive(:last_operand).exactly(n).times {|o| o }
            subject.should_receive(:last_operator).exactly(n).times {|o| o }
          end
          before do
            settings = {
              :minus => true, :min => 2, :max => 2,
              :digits => 2, :term_number => n,
            }
            @problems = subject.generate(settings)
          end
          it { @problems.should have(1).problem }
          it { @problems.first.split(@opt_pattern).should have(n).operands }
          it { @problems.first.scan(@opt_pattern).should have(n-1).operator }
          it { @problems.first.split(@opt_pattern).each {|operand| operand.should match(/\./) } }
          it { @problems.first.split(@opt_pattern).each {|term| term.should match(/\d+\.\d+/) } }
        end
      end
    end
  end
end

