# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Generator

  describe ComplexFractionalArithmetic do

    subject{ ComplexFractionalArithmetic.new }

    before(:all) { @opt_pattern = %r| [\-\+\*] | }

    it_should_behave_like 'Arithmetic'

    it do
      subject.should_receive(:fraction)
      subject.__send__(:operand)
    end

    context 'create expressoin' do
      ([1] + (2..100).to_a.shuffle[0, 9]).combination(2) do |i, j|
        context "#{i}/#{j}" do
          before do
            settings = {
              :numerator_term_min   => i, :numerator_term_max   => i,
              :denominator_term_min => j, :denominator_term_max => j,
            }
            @problems = subject.generate(settings)
          end
          it { @problems.should have(1).problem }
          it { @problems.first.split(/\//).should have((i + 1) + (j + 1)).operands }
          it { @problems.first.scan(@opt_pattern).should have((i - 1) + (j - 1)).operator }
        end
      end
    end
  end
end

