# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/spec_helper.rb'

module Mint

  module Generator

    context 'generator factory' do

      it 'can create generattor' do
        generator = Factory.create(:ordinary_arithmetic)
        generator.should be_an_instance_of(OrdinaryArithmetic)
      end

      it 'can create another type generator' do
        class Fraction
          def initialize(amount); end
        end
        generator = Factory.create(:fraction)
        generator.should be_an_instance_of(Fraction)
      end

      it 'can specify amount of problems' do
        generator = Factory.create(:ordinary_arithmetic, 5)
        generator.instance_variable_get(:@amount).should == 5
      end

      it 'returns nil when type is invalid' do
        Factory.create(:hogehoge).should be_nil
      end
    end
  end

  module Solver

    context 'solver factory' do

      module Maxima

        context Maxima do

          it 'can generate solver' do
            solver = Factory.create(:ordinary_arithmetic)
            solver.should be_an_instance_of(OrdinaryArithmetic)
          end
        end
      end
    end
  end
end

