# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

describe MintExpressionParser do

  subject { MintExpressionParser.new }

  context 'good expression' do

    # existing problems
    ProblemExamples.get(:original, :existing).
      each do |input, output|
        it input do
          expect {
            expression = subject.parse(input)
            expression.should == subject.parse(output)
          }.to_not raise_error
        end
      end
  end

  context 'bad expression' do
    ProblemExamples.get(:bad_patterns).
      each do |input, output|
        it input do
          expect { subject.parse(input).to_s }.to raise_error
        end
      end
  end
end
