# -*- coding: utf-8 -*-

module Mint::Generator

  #
  # 部分分数展開の問題を生成するジェネレータ
  #
  # == オプション
  # [_order_min_]
  #   生成する式の次数の最小値を１以上の整数で指定します。
  # [_order_max_]
  #   生成する式の次数の最大値を１以上の整数で指定します。
  #   _order_min_ より小さい値を指定することは出来ません。
  # [_x_]
  #   使用可能な変数の文字を配列で指定します。
  #   文字列の代わりに配列の形で文字列のペアを
  #   指定すると、２変数を使用した式を生成します。
  # [_factor_min_]
  #   生成する式の各項の最小値を０以上の整数で指定します。
  # [_factor_max_]
  #   生成する式の各項の最大値を０以上の整数で指定します。
  #   _factor_min_ よりも小さい値を指定することは出来ません。
  # [_factor_minus_]
  #   真を指定すると、負も値を生成します。
  # [_coefficient_min_]
  #   分母の係数の最小値を１以上の整数で指定します。
  # [_coefficient_max_]
  #   分母の係数の最大値を１以上の整数で指定します。
  #   _coefficient_min_ より小さい値は指定できません。
  # [_coefficient_minus_]
  #   真を指定すると分母の係数として負の値を生成します。
  # [_numerator_min_]
  #   生成する分子の最小値を０以上の整数で指定します。　
  # [_numerator_max_]
  #   生成する分子の最大値を０以上の整数で指定します。　
  #   _numerator_min_ より小さい値を指定することは出来ません。
  # [_numerator_minus_]
  #   真を指定すると分子に負の値も生成します。
  #
  class PartialFractionExpansion < HighOrderExpression

    private

    include Utilities

    option :order_min,         2
    option :order_max,         2
    option :factor_min,        1
    option :factor_max,        100
    option :factor_minus,      false
    option :coefficient_min,   1
    option :coefficient_max,   1
    option :coefficient_minus, false
    option :numerator_min,     1
    option :numerator_max,     1
    option :numerator_minus,   false

    def expression
      partial_fraction
    end

    def partial_fraction
      min, max, minus = options.values_at(:numerator_min, :numerator_max, :numerator_minus)
      numerator_part   = create_integer(min, max, minus)
      denominator_part = expansion
      "#{numerator_part}/#{denominator_part}"
    end
  end
end

