# -*- coding: utf-8 -*-

module Mint::Solver::Maxima

  class QuadraticEquation < Base

    def solve(problem) # :nodoc:
      unless problem.instance_of?(Mint::Expression)
        raise 'need to Mint::Expression'
      end
      answer = do_solve(problem)
      answer[1..-2].split(',').map {|x|
        Mint::Builder.build(x.match(/\Ax = (.*)\z/)[1])
      }
    end

    private
    def solve_problem(problem)
      unless x = problem.match(/([a-zA-Z])/)
        raise 'quadratic equation must have at least 1 variable'
      end
      solve_equation("#{problem} = 0", x)
    end
  end
end

