# -*- coding: utf-8 -*-

module Mint

  require 'singleton'

  class FactoryBase

    include Singleton

    private
    def self.constantize(name)
      name.to_s.split('_').map(&:capitalize).join
    end
  end

  module Generator

    class Factory < Mint::FactoryBase
      def self.create(type, amount = 1)
        Generator.const_get(constantize(type)).new(amount)
      rescue NameError
        nil
      end
    end
  end

  module Solver

    class Factory < Mint::FactoryBase
      def self.create(type, context = Maxima)
        context.const_get(constantize(type)).new
      rescue NameError
        nil
      end
    end

    module Maxima
      class Factory
        def self.create(type)
          Solver::Factory.create(type, Maxima)
        end
      end
    end
  end
end

