#!/usr/bin/perl

# require  #{{{
our $is_debug = 1;

if ($is_debug) {
    use CGI::Carp qw(fatalsToBrowser);
    use Data::Dumper;
}
use strict;
use warnings;
use CGI qw(:standard);
use File::Copy;

#}}}

our $data_dir = 'data';

# globals  #{{{
our $this_url = '';
our $default_password = 'minoradmin';
our %config = (
    password => '',
    site_name => 'Minor',
    content_type => 'text/html; charset=UTF-8',
    expires => '1209600',
    attach => 'files',
    this_url => ''
);
our $path_info = '';
our $adminmenu = '';
our %adminmenu = ();
our $body  = '';
our $title = '';
our $page_url = '';
our $is_frontpage = 0;
our $is_post = 0;
our $is_login = 0;
our %default_contents = ();
our %action = ();
our %inline = ();

our $MPRE   = '\\$';
our $MLINE  = '\\-';
our $MBLOCK = '\\^';
our $MCLIP  = ';';
our $RBEGIN = '(?<!\\\\)\\[';
our $RPRE   = "^$RBEGIN([^\\[\\]$MPRE]+?)$MPRE\$(.*?)^$MPRE\\]\$";
our $RLINE  = "^$RBEGIN([^\\[\\]$MLINE]+?)-\\s+(.*?)\$";
our $RBLOCK = "^$RBEGIN([^\\[\\]$MBLOCK]+?)$MBLOCK\$(.*?)^\$";
our $RCLIP  =  "$RBEGIN([^\\[\\]]+?)(?:$MCLIP\\s+([^\\]]*)\s*)?\\]";

#}}}

if (!$::skip_minor_main) {
    &main; exit;
}

sub main {#{{{
    &init;

    my $a = url_param('a');
    $a = 'read' if !exists $::action{$a};
    $::action{$a}->();

    &setup;

    print "Content-Type: ", $::config{content_type}, "\n\n",
          eval &quote((&read_page('_template'))[2]);
}#}}}

#### action ####{{{

sub do_read {#{{{
    my ($is_exists, $title, $body ) = $::is_frontpage || $::is_login
        || (substr $::path_info, 0, 1) ne '_' ? &read_page($::path_info) : (0);
    if (!$is_exists) {
        print "Status: 404 Not Found\n";
        ($title, $body) = (&read_page('_notfound'))[1,2];
    }
    $::title = $title;
    $::body .= &convert($body);
}#}}}

sub do_new {#{{{
    if ($is_post && param('new')) {
        my $page = param('page');
        $page =~ s/\/$//;
        &redirect("$::page_url$page?a=edit");
    }

    $::title = 'New';
    $::body .= eval &quote((&read_page('_new'))[2]);
}#}}}

sub do_login {#{{{
    if ($is_post && param('login')) {
        &login(param('auto_login')) and &redirect($::this_url)
            if &auth_password(param('pwd'));
    }
    my $error = $::is_post? 'Incorrect Password.' : '';
    $::title = 'Login';
    $::body .= eval &quote((&read_page('_login'))[2]);
}#}}}

sub do_admin {#{{{
    my ($message, $error);
    if ($::is_post) { while (1) {
        if (param('change_password')) {
            $error = 'Incorrect Password.' and last
                if !&auth_password(param('old_password'));

            my $pwd  = param('new_password_1');
            my $pwd2 = param('new_password_2');
            $error = 'New password is empty.' and last
                if !$pwd || !$pwd2;
            $error = 'New passwords do not match.' and last
                if $pwd ne $pwd2;

            srand();
            my @salt = ('A'..'Z', 'a'..'z', '0'..'9', '.', '/');
            my $salt = $salt[int(rand(64))] . $salt[int(rand(64))];
            $pwd = crypt($pwd, $salt);

            $::config{password} = $pwd;
            $message = 'Password changed successfully.';
        } elsif (param('general_options')) {
            $::config{site_name} = param('site_name');
            $::config{this_url}  = $::this_url = param('this_url');
            $message = 'General options changed successfully.';
        }

        my @config;
        map { push @config, "$_=$::config{$_}"; } keys %::config;
        &write_page('_config', 'Config', (join "\n", @config));
        
    last; } }
    $::title = 'Admin';
    $::body .= eval &quote((&read_page('_admin'))[2]);
}#}}}

sub make_attach_list {#{{{
    my $dir = shift;
    opendir my $dh, $dir;
    my @dirs = grep {-f "$dir/$_"} readdir $dh; closedir $dh;
    return @dirs;
}#}}}

sub do_edit {#{{{
    my ($error, $message);
    my ($title, $body, $preview);
    my $attach_path = &make_attach_path($::path_info);

    if ($::is_post) {
        if (param('save')) {
            my $is_exists = (-f &make_page_path($::path_info));
            &write_page($::path_info, param('title'), param('body'));
            &write_recent($::path_info, $is_exists? 'u' : 'n', param('title')) if !param('sage');
            &redirect($::page_url);
        } elsif (param('attach')) {
            my $fh = upload('file');
            eval {
                $error = "Upload failed. (Unknown error)" and die
                    if !$fh;
                $error = "Upload failed. (Attach confing is not completed)" and die
                    if !$::config{attach};
                $error = "Upload failed. (Can't create attach directory)" and die
                    if (!-d $::config{attach}) && !(mkdir $::config{attach}, 644)
                    || (!-d $attach_path)      && !(mkdir $attach_path,      644);

                my $to = "$attach_path/" . param('file');
                my $from = tmpFileName($fh);
                $error = "Upload failed. (Can't move/copy: $!)" and die
                    if !(move $from, $to) && !(copy $from, $to);
                $message = 'Uploaded successfully.';
            };
            close $fh if $fh;
        } elsif (param('move')) {
        } elsif (param('preview')) {
            $title = param('title');
            $body  = param('body');
            $preview = &convert($body);
        }
    } else {
        ($title, $body) = (&read_page($::path_info))[1,2];
    }

    #
    my @a = &make_attach_list($attach_path);
    my $attach_list = "@a";
    #

    $title = &escape($title);
    $body  = &escape($body);

    $::title = 'Edit';
    $::body .= eval &quote((&read_page('_edit'))[2]);
}#}}}

sub do_logout {#{{{
    print 'Set-Cookie: ', &make_session_cookie, "\n";
    &write_page('_session', '', '');
    &redirect($::this_url);
}#}}}

#}}}

#### auth ####{{{

sub make_session_cookie {#{{{
    my ($value, $expires) = @_;
    my $path = $ENV{SCRIPT_NAME};
    $path =~ s{/[^/]*$}{/};

    if ($value) {
        $expires = '+'.($expires - time).'s' if $expires;
    } else {
        $value = '';
        $expires = '-1m';
    }

    cookie(
        -name => 'session', 
        -value => $value,
        -expires => $expires,
        -path => $path
    );
}#}}}

sub login {#{{{
    my $is_save = shift;
    my $ip = $ENV{REMOTE_ADDR};
    my $id = ''.rand(1);
    my $expires = time + ($is_save ? $::config{expires} : 86400);

    my $session = (&read_page('_session'))[2] ."$ip $id $expires\n";
    &write_page('_session', 'Session', $session);

    $expires = 0 unless $is_save;
    print 'Set-Cookie: ', &make_session_cookie($id, $expires), "\n";

    return $::is_login = 1;
}#}}}

sub auth_password {#{{{
    my $pwd = shift;
    return (crypt($pwd.$::default_password, $::config{password}) eq $::config{password})
        if $::config{password};
    return ($pwd eq $::default_password);
}#}}}

#}}}

#### inline  ####{{{

sub inline_a {#{{{
    my ($param, $text) = @_;

    $param = &explode($param);
    my $href = $param->{h}; delete $param->{h}; 
    if ($href) {
        $href = $::this_url . (substr $href, 1)
            if (substr $href, 0, 1) eq '/';
        $param->{href} = $href;
    }

    $param = &implode($param);

    $param = " $param" if $param;
    return "<a$param>$text</a>";
}#}}}

sub inline_recent {#{{{
    my $param = &explode(shift);
    my $n = $param->{n}; $n ||= 30;
    my $i = 0;
    my @texts;

    foreach (&read_recent) {
        my @r = split /\s/;
        next if $r[0] eq 'frontpage';
        my ($da, $mo, $yr) = (localtime($r[2]))[3, 4, 5];
        my $date = sprintf("%04d-%02d-%02d", $yr + 1900, $mo + 1, $da);
        my $type = $r[1] eq 'n' ? 'NEW!' : 'UP!';
        push @texts, "<li>$date <a href=\"$::this_url$r[0]\">$r[3]</a> <sup>$type</sup></li>";

        last if ++$i >= $n;
    }
    return "<ul>\n" . (join "\n", @texts) . "</ul>";
}#}}}

sub inline_pre {#{{{
    my ($param, $text) = @_;

    $param = " $param" if $param;
    $text  = &escape($text);
    return "<pre$param>$text</pre>";
}#}}}

sub write_recent {#{{{
    my ($path, $type, $title) = @_;

    my $recent = "$::data_dir/_recent";
    my $is_create = (!-f $recent);

    open my $fh, '>>', $recent;
    print $fh "\n" if $is_create;
    print $fh "$path $type " . time . " $title\n";
    close $fh;
}#}}}

sub read_recent {#{{{
    open my $fh, "< $::data_dir/_recent";
    seek $fh, -1024, 2;
    my $data;
    read $fh, $data, 1024;
    close $fh;

    my @data = split /\n/, $data;
    shift @data;
    return reverse @data;
}#}}}

sub implode {#{{{
    my $param = shift;
    my @param; 
    map { push @param, qq/$_="$param->{$_}"/; } keys %$param;
    return join ' ', @param;
}#}}}

sub explode {#{{{
    my @param = split /\s+/, shift;
    my %param;
    foreach (@param) {
        my ($name, $value) = split /=/, $_; 
        $value = substr $value, 1 if (index $value, 0) eq '"';
        $value = substr $value, 0, -1 if (index $value, (length $value-1)) eq '"';
        $param{$name} = $value;
    }
    return \%param;
}#}}}

sub call_inline {#{{{
    my ($tag, $param) = split /\s+/, shift, 2;
    my $text = shift;

    if (exists $::inline{$tag}) {
        return $::inline{$tag}->($param, $text) 
    } else {
        $param = " $param" if $param;
        return "<$tag$param>$text</$tag>";
    }
}#}}}

#}}}

sub convert {#{{{
    $_ = shift . "\n\n";

    s/\r\n/\n/g;
    s/\r/\n/g;
    s/\\/\\\\/g;

    # pre
    s/$RPRE/
        ($_ = &call_inline($1, $2)) =~ s{\n}{\\n}g;
        $_;
    /msge;

    # block
    s/$RBLOCK/&call_inline($1, $2)/msge;

    # line
    s/$RLINE/&call_inline($1, $2)/msge;

    # clip
    s/$RCLIP/
        $_ = &call_inline($1, $_) foreach (@_ = split(\/@\/, $2)); 
        @_? (join '', @_) : (&call_inline($1));
    /msge;

    s/(?<!>)$/<br \/>/msg;
    s/(?<!\\)\\n/\n/g;
    s/\\\\\[/\[/g;
    s/\\\\/\\/g;

    return $_;
}#}}}

sub write_page {#{{{
    my ($page, $title, $body) = @_;
    my $fpath = &make_page_path($page);

    $body =~ s/\r\n/\n/g;
    $body =~ s/\r/\n/g;

    open my $fh, '>', $fpath;
    print $fh $title, "\n", $body;
    close $fh;
    return 1;
}#}}}

sub make_page_path {
    my $page = shift;
    $page = &url_enc($page);
    return "$data_dir/$page";
}

sub read_page {#{{{
    my $page = shift;
    my $fpath = &make_page_path($page);
    if (-f $fpath) {
        open my $fh, '<', $fpath;
        my $title = <$fh>;
        my $page = join '', <$fh>;
        close $fh;
        return (1, $title, $page);
    } elsif (exists $::default_contents{$page}) {
        return (1, $::default_contents{$page}{title}, 
                   $::default_contents{$page}{body});
    }
    return (0, '', '');
}#}}}

sub eval_page {#{{{
    return eval &quote((&read_page(shift))[2]);
}#}}}

sub setup {#{{{
    foreach my $name (sort keys %adminmenu) {
        my $link = (split /_/, $name, 2)[1];
        $::adminmenu .= qq(<a href="$::page_url?$::adminmenu{$name}">$link</a>\n);
    }

    $::title = $is_frontpage ? $::config{site_name}
                             : &escape($::title)." &laquo; $::config{site_name}";

    $::css  = &eval_page('_css');
    $::menu = &eval_page('_menu');
}#}}}

#### init ####{{{

sub init {#{{{
    &critical_error("Can't create data directory. (Data dir: \"$::data_dir\")") 
        if (!-d $::data_dir) && !(mkdir $::data_dir, 0711);

    &critical_error("Can't create config file.") 
        if !&init_config;

    &init_session;

    $ENV{PATH_INFO} =~ m{^/*(.*?)/*?$};
    $::path_info = $1 ? $1 : 'frontpage';

    $::is_frontpage = $1 ? 0 : 1;

    $::data_dir =~ s{/$}{};

    $::config{attach} =~ s{/$}{};

    if ($::config{this_url}) {
        ($::this_url = $::config{this_url}) =~ s{^(.*[^/])$}{$1/};
    } else {
        $::this_url = url().'/';
    }

    $::page_url = $::is_frontpage ? $::this_url
                                  : $::this_url.$::path_info;

    $::is_post = $ENV{REQUEST_METHOD} eq 'POST';

    my $page = '-';
    while (<DATA>) {
        if (/^=([_A-Z0-9]+)$/) {
            $page = lc $1;
            $::default_contents{$page}{title} = <DATA>;
        } else {
            $::default_contents{$page}{body} .= $_;
        }
    }

    %::adminmenu = $is_login ? (
        '000_Edit'   => 'a=edit',
        '100_New'    => 'a=new',
        '200_Admin'  => 'a=admin',
        '400_Logout' => 'a=logout',
    ) : (
        '000_Login'  => 'a=login',
    );

    %::action = $is_login ? (
        'edit'   => \&do_edit,
        'new'    => \&do_new,
        'logout' => \&do_logout,
        'read'   => \&do_read,
        'admin'  => \&do_admin,
    ) : (
        'read'   => \&do_read,
        'login'  => \&do_login,
    );

    %::inline = (
        'a' => \&inline_a,
        'recent' => \&inline_recent,
        'pre' => \&inline_pre,
    );
}#}}}

sub init_config {#{{{
    my ($is_exists, $config) = (&read_page('_config'))[0,2];

    if ($is_exists) {
        map { @_ = split /=/, $_, 2; $::config{$_[0]} = $_[1] if $_[0]; } 
            split /\r?\n/, $config;
        1;
    } else {
        map { $config .= "$_=$::config{$_}\n" if $_; } keys %::config;
        &write_page('_config', 'Config', $config);
    }
}#}}}

sub init_session {#{{{
    return if !($ENV{HTTP_COOKIE} =~ m/\bsession=(\S+)/);
    my $id = $1;
    my $ip = $ENV{REMOTE_ADDR};
    my @session = split /\r?\n/, (&read_page('_session'))[2] 
        or return;

    foreach (@session) {
        my ($ip2, $id2, $ex2) = split /\s/;
        return if ($ip2 eq $ip)
              and ($id2 eq $id)
              and ($ex2 > time)
              and ($::is_login = 1);
    }
}#}}}

#}}}

#### utility ####{{{

sub make_attach_path {#{{{
    $_ = shift;
    s/\//_/g;
    $_ = &url_enc($_);
    $_ = "$::config{attach}/$_";
    $_;
}#}}}

sub quote {#{{{
    $_ = shift;
    s/\\/\\\\/g;
    s/"/\\"/g;
    return qq("$_");
}#}}}

sub critical_error {#{{{
    my $msg = shift;
    print << "EOD";
Content-Type: $::config{content_type}

<html>
<head><title>Critical Error</title></head>
<body>$msg</body>
</html>
EOD
    exit;
}#}}}

sub redirect {#{{{
    print "Location: $_[0]\n\n";
    exit;
}#}}}

sub escape {#{{{
    $_ = shift;
    s/&/&amp;/g;
    s/</&lt;/g;
    s/>/&gt;/g;
    s/"/&quot;/g;
    s/'/&#39;/g;
    return $_;
}#}}}

sub url_enc {#{{{
    my $s = shift;
    $s =~ s/(\W)/'%'.unpack('H2',$1)/ge;
    return $s;
}#}}}

sub url_dec {#{{{
    my $s = shift;
    $s =~ s/%([0-9a-f]{2})/pack('H2',$1)/gei;
    return $s;
}#}}}

#}}}

__DATA__
=_TEMPLATE
Template
<html>
<head>
   <title>$::title</title>
   <style type="text/css">$::css</style>
</head>
<body>
<div class="main">
   <div class="header">
       <div class="menu">$::menu $::adminmenu</div>
       <h1><a href="$this_url">$::config{site_name}</a></h1>
   </div>
   <div class="contents">
       $::body
   </div>
   <div class="footer">
       Powered by <a href="http://zisaku.org/minor/">Minor</a>
   </div>
</div>
</body>

=_CSS
CSS
body { font-family: Verdana, Arial, sans-serif; font-size: 0.8em; }
    div.main { width: 650px; margin: 0 auto; }

=_NOTFOUND
Not Found
<h2>404 Not Found</h2>
Sorry, page not found.

=_FRONTPAGE
Minor
Thank you for using Minor!

=_EDIT
Edit
$preview
<h3 id="minor_edit_form">Edit</h3>
<p style="color:red">$error</p>
<p style="color:green">$message</p>
<form action="$::page_url?a=edit" method="post" name="minor_form">
    <div id="minor_bodyc">
    <input type="text" name="title" value="$title" size="80" />
    <a href="javascript:void(0)" onclick="minorExpand.call(this,'minor_body',true)" id="expand">[Expand]</a><br />
    <textarea name="body" cols="80" rows="30" id="minor_body">$body</textarea>
    </div>
    <div id="minor_partc" style="display:none">
    <strong style="line-height:1.7em">Partial mode</strong> 
    <a href="javascript:void(0)" onclick="minorExpand.call(this,'minor_part',true)" id="expand">[Expand]</a>
    <a href="javascript:void(0)" id="minor_close_partial">[x]</a>
    <textarea cols="80" rows="30" id="minor_part"></textarea><br />
    </div>
    <input type="submit" name="preview" value="Preview" />
    <label for="minor_backup"><input type="checkbox" name="backup" id="minor_backup" />Backup</label>
    <label for="minor_sage"><input type="checkbox" name="sage" id="minor_sage" />Sage</label>
    <input type="submit" name="save" value="Save" />
</form>
<form action="$::page_url?a=edit" method="post" name="minor_form">
<h3>Delete</h3>
    <label for="minor_delete_ok"><input type="checkbox" name="delete_ok" id="minor_delete_ok" />Really?</label>
    <input type="submit" name="delete" value="Delete" onclick="if(!this.parentNode.delete_ok.checked) return false; return confirm('Delete this page really? (Impossible to rollback)')" />
</form>
<form action="$::page_url?a=edit" method="post" name="minor_form" enctype="multipart/form-data">
<h3>Attachment</h3>
    $attach_list
    <input type="file" name="file" size="80" />
    <input type="submit" name="attach" value="Upload" />
</form>
<form action="$::page_url?a=edit" method="post" name="minor_form">
<h3>Move</h3>
    Move to: <input type="text" name="dist" value="$::path_info" size="50" />
    <input type="submit" name="move" value="Move" />
</form>
<script> /**/

function find(id) {
    return document.getElementById(id);
}
    
function minorExpand(id, isExpand, rows) {
    var t = find(id);
    if(isExpand) {
        this.onclick = (function(rows) {
            return function() { minorExpand.call(this, id, false, rows); };
        })(t.rows);
        for (var n = 0, p = 0; (p = t.value.indexOf("\n", p)) > 0 || (t.rows = n*1.2) && false; ++p, ++n);
        this.innerHTML="[Collapse]";
    } else {  
        this.onclick = function() { minorExpand.call(this, id, true); };
        t.rows=rows;
        this.innerHTML="[Expand]";
    } 
    return false;
}

(function() {
    for (var lv = [2, 3, 4, 5, 6], i = 0, n = lv.length; i < n; ++i)
        observe(lv[i]);

    var body = find("minor_body"), bodyc = find("minor_bodyc");
    var part = find("minor_part"), partc = find("minor_partc");
    var close = find("minor_close_partial");
    
    function observe(level)
    {
        for (var h = document.getElementsByTagName("h" + level), i = 0, n = h.length; i < n; ++i) {
            h.item(i).ondblclick = (function(pos) { 
                return function(e) { edit.call(this, e, pos); } 
            })(i);
        }
    }

    function edit(e, pos)
    {
        var re = new RegExp("(?=[\\[<]" + this.nodeName + ")", "gmi");
        var texts = body.value.split(re);
        if (!texts[0].match(re)) {
            ++pos;
        }

        var lv = this.nodeName.match(/[0-9]+/)[0];
        var re = new RegExp("(?=[\\[<]h[1-" + lv + "])", "mi");
        var chunks = texts[pos].split(re);
        chunks.unshift(pos, 1)
        texts.splice.apply(texts, chunks);

        part.value = texts[pos];
        bodyc.style.display = "none";
        partc.style.display = "block";
        location.href = "#minor_edit_form";

        var merge = function() {
            texts[pos] = part.value;
            body.value = texts.join("");
        };
        close.onclick = function() {
            merge();
            bodyc.style.display = "block";
            partc.style.display = "none";
            return false;
        };
        document.forms.minor_form.onsubmit = merge;
    }
})();
</script>

=_NEW
New
<form action="$::this_url?a=new" method="post">
    Page URL :
    <input type="text" name="page" size="50" />
    <input type="submit" name="new" value="Create" />
</form>

=_LOGIN
Login
<form action="$::this_url?a=login" method="post" name="minor_login">
    <p style="color:red">$error</p>
    <input type="password" name="pwd" size="30" />
    <input type="submit" name="login" value="Login" /><br />
    <label for="auto_login"><input type="checkbox" id="auto_login" name="auto_login" />Auto login</label>
</form>
<script> document.forms.minor_login.pwd.focus(); </script>

=_ADMIN
Admin
<p style="color:green">$message</p>
<p style="color:red">$error</p>
<form action="$::this_url?a=admin" method="post">
<h3 id="change_password">Change Password</h3>
Old: <input type="password" name="old_password" size="40" /><br />
New (1): <input type="password" name="new_password_1" size="40" /><br />
New (2): <input type="password" name="new_password_2" size="40" /> (Confirm)<br />
<br /><input type="submit" name="change_password" value="Save" /><br /><br /><br />
</form>
<h3 id="custom_style">Custom Style</h3>
<a href="@{[$::this_url]}_template?a=edit">Edit Template</a><br />
<a href="@{[$::this_url]}_css?a=edit">Edit CSS</a><br />
<br /><br />
<form action="$::this_url?a=admin" method="post">
<h3 id="general_options">General Options</h3>
Site Name: <input type="text" name="site_name" size="40" value="$::config{site_name}" /><br />
This URL: <input type="text" name="this_url" size="40" value="$::config{this_url}" /><br />
<br /><input type="submit" name="general_options" value="Save" /><br /><br />
</form>

=_MENU
Menu
<a href="$::this_url">Top</a>
