/**
 * httpdサーバのサンプルです。
 * ROMにある定義済みファイルの入出力と、クロスドメインRESTが確認できます。
 */
#include "boot/sketch.h"

#include "NyLPC_net.h"
#include "NyLPC_uipService.h"
#include "NyLPC_http.h"
#include "NyLPC_utils.h"
#include <stdio.h>
#include <string.h>
/**
 * UDP loopback test
 */
NyLPC_TcNet_t net;
NyLPC_TcUdpSocket_t udp;
char buf[512];
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	NyLPC_cNet_initialize(&net);
	NyLPC_cUdpSocket_initialize(&udp,9999,buf,512);
}


void loop(void)
{
	struct NyLPC_TIPv4Addr client_addr;
	const void* b;
	int rs;
	const struct NyLPC_TIPv4RxInfo* info;
	NyLPC_TcNetConfig_t c2;
	NyLPC_TIPv4Addr_set(&client_addr,192,168,128,195);

	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNetConfig_setIpAddr(&c2,192,168,128,39);
	NyLPC_cNetConfig_setGateway(&c2,192,168,128,254);
	NyLPC_cNet_start(&net,&c2);
	for(;;)
	{
		rs=NyLPC_cUdpSocket_precv(&udp,&b,&info,1000);
		if(rs>0){
			NyLPC_cUdpSocket_send(&udp,&info->peer_ip,info->peer_port,b,rs,1000);
			NyLPC_cUdpSocket_pseek(&udp);
		}
	}
}


