/**
 * DHCPクライアントのサンプルです。
 * DHCPサーバからIPアドレスを受け取ってネットワークを起動します。
 */
#include "boot/sketch.h"

#include "NyLPC_net.h"
#include "NyLPC_utils.h"
#include <stdio.h>
#include <string.h>

NyLPC_TcNet_t net;

void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	NyLPC_cNet_initialize(&net);
}

void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	//デフォルト設定の呼び出し
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	//DHCP
	NyLPC_cNet_requestAddrDhcp(&net,&(c2.super),3);
	NyLPC_cNet_start(&net,&c2);
	//受信待ち
	for(;;){
	}
}




