CodeMirror.defineMode('z80', function()
{
	var k_wmwm_wmhd =/^(and|x?or|add|sub|mul|mget|mput|ld)\b/i;
	var k_wm        =/^(not|sget)\b/i;
	var k_wmwm_wmh8 =/^(shr|shl)\b/i;
	var k_none_h8   =/^(nop)\b/i;
	var k_wm_hd     =/^(call|sput)\b/i;
	var k_none      =/^(exit)\b/i;
	var vk_def      =/^(\.end)\b/i;
	var vk_db       =/^(\.d32)\b/i;
	
	var v_hd=/^(0x[0-9a-f]{1,8}|[0-9]{1,10})\b/i;
	var v_h8=/^(0x[0-9a-f]{1,2}|[0-9]{1,3})\b/i;
	var v_wm=/^\#[01234567]\b/i;
	function ishd(w){return v_hd.test(w)?'number':false;}
	function ish8(w){return v_h8.test(w)?'number':false;}
	function iswm(w){return v_wm.test(w)?'number':false;}
	function iswmhd(w){return v_hd.test(w)?'number':v_wm.test(w)?'number':false;}
	function iswmh8(w){return v_h8.test(w)?'number':v_wm.test(w)?'number':false;}
	function isdelim(w){return w==","?'keyword':false;}
	return {startState: function()
	{
		return {context:[]};
	}, token: function(stream, state)
	{
		if (!stream.column())
		{
			state.context =null;
		}
		
		if (stream.eatSpace())
			return null;
		
		if (stream.eatWhile(/\w|\#|\./))
		{
			var w = stream.current();
			if(state.context==null){
				if(k_wmwm_wmhd.test(w)){
					state.context=[iswm,isdelim,iswmhd];
				}else if(k_wm.test(w)){
					state.context=[iswm];
				}else if(k_wmwm_wmh8.test(w)){
					state.context=[iswm,isdelim,iswmh8];
				}else if(k_none_h8.test(w)){
					state.context=[ish8];
				}else if(k_wm_hd.test(w)){
					state.context=[iswmhd];
				}else if(k_none.test(w)){
					state.context=[];
				}else if(vk_def.test(w)){
					state.context=[];
					return 'def'; 
				}else if(vk_db.test(w)){
					state.context=[ishd];
					return 'def'; 
				}else{
					return 'error';
				}			
				return 'keyword';
			}else{
				if(state.context.length!=0){
					var r=state.context[0](w);
					if(r!==false){
						state.context.shift();
						return r;
					}
				}
			}
			return 'error';
		}
		if(stream.eat(','))
		{
			var w = stream.current();
			if(state.context.length!=0){
				var r=state.context[0](w);
				if(r!==false){
					state.context.shift();
					return r;
				}
			}
			return 'error';
		}
		if (stream.eat(';')){stream.skipToEnd();return 'comment';}
		else{stream.next();}
		return null;
	}};
});
CodeMirror.defineMIME("text/x-imicil", "MiMicIL");
