#include "NyLPC_cNetConfig.h"
#include "../flash/NyLPC_cMiMicConfiglation.h"
/**
 * IPアドレスはネットワークオーダーで格納する。
 * 構造体は4バイトアライメントであること。
 */
struct TNetConfigMemMap
{
	/**
	 * ROM焼検出用。0xFFFFFFFFを書く
	 */
	NyLPC_TUInt32	fast_boot;
	NyLPC_TUInt16	version;
	NyLPC_TUInt16	interface_type;
	NyLPC_TUInt32	mac_00_01_02_03;
	NyLPC_TUInt32	mac_04_05_xx_xx;
	/** network order ip address*/
	NyLPC_TUInt32	ipv4_addr_net;
	/** network order mask value*/
	NyLPC_TUInt32	ipv4_mask_net;
	/** network order route*/
	NyLPC_TUInt32	ipv4_drut_net;
//	NyLPC_TUInt32	ipv4_port;
//	NyLPC_TUInt32	accessmode;
};

static void loadFromMemory(NyLPC_TcNetConfig_t* i_inst);

void NyLPC_cNetConfig_initialize(NyLPC_TcNetConfig_t* i_inst)
{
	loadFromMemory(i_inst);


}

/**
 * ユーザコンフィギュレーションを更新する。
 * この関数をコールするときは、割込/FreeRTOSを一時停止すること。
 */
/*
NyLPC_TBool NyLPC_cNetConfig_saveToOnchipFlash(NyLPC_TcNetConfig_t* i_inst)
{
	NyLPC_TUInt8* pdata;
	NyLPC_TcOnchipFlashWriter_t s;
	struct TNetConfigMemMap tmp;
	NyLPC_cOnchipFlashWriter_initialize(&s);
	//書込みデータを作成
	tmp.fast_boot=0xffffffff;
	tmp.version  =i_inst->version;
	tmp.interface_type=NyLPC_cNetConfig_INTERFACE_TYPE_ETHERNET;
	pdata=i_inst->interface_setting.ethernet.eth_mac.addr;
	tmp.mac_00_01_02_03=(((NyLPC_TUInt32)pdata[0])<<24)|(((NyLPC_TUInt32)pdata[1])<<16)|(((NyLPC_TUInt32)pdata[2])<<8)|(((NyLPC_TUInt32)pdata[3])<<0);
	tmp.mac_04_05_xx_xx=(((NyLPC_TUInt32)pdata[4])<<24)|(((NyLPC_TUInt32)pdata[5])<<16);
	tmp.ipv4_addr_net=i_inst->interface_setting.ethernet.ip_addr.v;
	tmp.ipv4_mask_net=i_inst->interface_setting.ethernet.netmask.v;
	tmp.ipv4_drut_net=i_inst->interface_setting.ethernet.dr_addr.v;

	//イレース
	if(!NyLPC_cOnchipFlashWriter_elase(&s,MIMIC_CONFIGLATION_FLASH_SECTOR,MIMIC_CONFIGLATION_FLASH_SECTOR)){
		NyLPC_OnErrorGoto(Error);
	}
	//コンフィギュレーションを書き込む。
	if(!NyLPC_cOnchipFlashWriter_writeSector(&s,MIMIC_CONFIGLATION_FLASH_SECTOR,0x00000000,&tmp,sizeof(struct TNetConfigMemMap))){
		NyLPC_OnErrorGoto(Error);
	}
	//ユーザコンフィギュレーションをONにする。
	if(setUserConfigulation()){
		NyLPC_OnErrorGoto(Error);
	}
	NyLPC_cOnchipFlashWriter_finalize(&s);
	return NyLPC_TBool_TRUE;
Error:
	NyLPC_cOnchipFlashWriter_finalize(&s);
	return NyLPC_TBool_FALSE;
}
*/


#define ETHERNET_FRAME_LEN 1480
static void loadFromMemory(NyLPC_TcNetConfig_t* i_inst)
{
	struct NyLPC_TEthAddr ea;
	struct NyLPC_TIPv4Addr ip,mask,drt;
	const struct NyLPC_TMimicConfigulation* pdata=NyLPC_cMiMicConfiglation_loadMiMicConfigulation();
	//値の読み出し
	ea.addr[0]=(NyLPC_TUInt8)((pdata->mac_00_01_02_03>>24)&0xff);
	ea.addr[1]=(NyLPC_TUInt8)((pdata->mac_00_01_02_03>>16)&0xff);
	ea.addr[2]=(NyLPC_TUInt8)((pdata->mac_00_01_02_03>> 8)&0xff);
	ea.addr[3]=(NyLPC_TUInt8)((pdata->mac_00_01_02_03>> 0)&0xff);
	ea.addr[4]=(NyLPC_TUInt8)((pdata->mac_04_05_xx_xx>>24)&0xff);
	ea.addr[5]=(NyLPC_TUInt8)((pdata->mac_04_05_xx_xx>>16)&0xff);
	ip.v=NyLPC_htonl(pdata->ipv4_addr_net);
	mask.v=NyLPC_htonl(pdata->ipv4_mask_net);
	drt.v=NyLPC_htonl(pdata->ipv4_drut_net);
	i_inst->version=1;
	i_inst->interface_type=NyLPC_cNetConfig_INTERFACE_TYPE_ETHERNET;
	NyLPC_cIPv4Config_initialzeForEthernet(&i_inst->interface_setting.ethernet,&ea,ETHERNET_FRAME_LEN);
	NyLPC_cIPv4Config_setDefaultRoute(&i_inst->interface_setting.ethernet,&drt);
	NyLPC_cIPv4Config_setIp(&i_inst->interface_setting.ethernet,&ip,&mask);
	return;
}



