/*
 * cConfiglationStorage.h
 *
 *  Created on: 2011/10/18
 *      Author: nyatla
 */

#include "NyLPC_stdlib.h"
#ifndef NYLPC_CCONFIGLATIONSTORAGE_H_
#define NYLPC_CCONFIGLATIONSTORAGE_H_


/**
 * IPアドレスはネットワークオーダーで格納する。
 */
struct NyLPC_TMimicConfigulation{
	/**
	 * ROM焼検出用。0xFFFFFFFFを書く
	 */
	NyLPC_TUInt32	fast_boot;
	NyLPC_TUInt32	mac_00_01_02_03;
	NyLPC_TUInt32	mac_04_05_xx_xx;
	NyLPC_TUInt32	ipv4_addr_net;
	NyLPC_TUInt32	ipv4_mask_net;
	NyLPC_TUInt32	ipv4_drut_net;
	NyLPC_TUInt32	ipv4_port;
	NyLPC_TUInt32	accessmode;
};

/**
 * ユーザコンフィギュレーションを更新する。
 * この関数は、RTOSが停止中に実行すること。
 * この関数は384バイト程度のスタックが必要です。
 */
NyLPC_TBool NyLPC_cMiMicConfiglation_updateConfigulation(const struct NyLPC_TMimicConfigulation* i_congfiglation);
/**
 * コンフィギュレーション値を返す。
 * この関数は、RTOSが停止中に実行すること。
 */
const struct NyLPC_TMimicConfigulation* NyLPC_cMiMicConfiglation_loadMiMicConfigulation(void);


#endif /* CCONFIGLATIONSTORAGE_H_ */
