/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#include "NyLPC_cTcpListener_protected.h"
#include "NyLPC_cTcpSocket_protected.h"
#include "NyLPC_cUipService_protected.h"
#include "NyLPC_cIPv4.h"
#include "NyLPC_stdlib.h"





/**
 * uipサービスが稼働中にのみ機能します。
 */
NyLPC_TBool NyLPC_cTcpListener_initialize(NyLPC_TcTcpListener_t* i_inst,NyLPC_TUInt16 i_port)
{
	NyLPC_TcUipService_t* srv=_NyLPC_TcUipService_inst;
	//uipサービスは初期化済であること。
	NyLPC_Assert(NyLPC_TcUipService_isInitService());
	//初期化
	NyLPC_cMutex_initialize(&(i_inst->_mutex));
	i_inst->_port=NyLPC_htons(i_port);
	//管理リストへ登録。
	return NyLPC_cIPv4_addListener(&(srv->_tcpv4),i_inst);
}

void NyLPC_cTcpListener_finaize(NyLPC_TcTcpListener_t* i_inst)
{
	NyLPC_TcUipService_t* srv=_NyLPC_TcUipService_inst;
	NyLPC_Assert(NyLPC_TcUipService_isInitService());
	//uipサービスは初期化済であること。
	if(!NyLPC_cIPv4_removeListener(&(srv->_tcpv4),i_inst)){
		//削除失敗、それは死を意味する。
		NyLPC_Abort();
	}
	return;
}

NyLPC_TBool NyLPC_cTcpListener_listen(NyLPC_TcTcpListener_t* i_inst,NyLPC_TcTcpSocket_t* i_sock,NyLPC_TUInt32 i_wait_msec)
{
	NyLPC_TcStopwatch_t sw;
	NyLPC_TBool ret;
	//サービスは稼働中であること。
	NyLPC_Assert(NyLPC_cUipService_isRun());

	//入力ソケットはCLOSEDであること。
	if(i_sock->tcpstateflags!=UIP_CLOSED){
		return NyLPC_TBool_FALSE;
	}
	//Listenerのリソースロック
	NyLPC_cMutex_lock(&(i_inst->_mutex));
	//listenターゲットのセット
	i_inst->_ref_sock=i_sock;
	//Listenerのリソースアンロック
	NyLPC_cMutex_unlock(&(i_inst->_mutex));


	//一定時間待つ。
	NyLPC_cStopwatch_initialize(&sw);
	NyLPC_cStopwatch_setNow(&sw);
	while(NyLPC_cStopwatch_elapseInMsec(&sw)<i_wait_msec){
		taskYIELD();
		//ステータス遷移が実行されていたら、ブレーク
		if(i_inst->_ref_sock->tcpstateflags==UIP_SYN_RCVD){
			break;
		}
	}
	NyLPC_cStopwatch_finalize(&sw);

	//Listenerのリソースロック
	NyLPC_cMutex_lock(&(i_inst->_mutex));
	//受領確認と戻り値の決定
	if(i_inst->_ref_sock->tcpstateflags==UIP_SYN_RCVD){
		ret=NyLPC_TBool_TRUE;
	}else{
		ret=NyLPC_TBool_FALSE;
	}
	//バインドしてあるソケットを解除
	i_inst->_ref_sock=NULL;
	//Listenerのリソースアンロック
	NyLPC_cMutex_unlock(&(i_inst->_mutex));
	return ret;
}

/**
 * この関数は、Uip受信タスクから実行します。
 */
NyLPC_TcTcpSocket_t* NyLPC_cTcpListener_makeSynRcvdSocket(NyLPC_TcTcpListener_t* i_inst,const NyLPC_TcIPv4Config_t* i_config,const NyLPC_TcIPv4Payload_t* i_payload)
{
	NyLPC_TcTcpSocket_t* sock=NULL;
	//パケットチェック。SYN設定されてる？
	if(!(i_payload->payload.tcp->flags & TCP_SYN)){
		//SYNない
		return NULL;
	}
	//Listenerのリソースロック
	NyLPC_cMutex_lock(&(i_inst->_mutex));
	if(i_inst->_ref_sock!=NULL){
		//listenターゲットが指定されていたら、ソケットステータスの遷移。CLOSED->SYN_RCVD
		if(NyLPC_cTcpSocket_setSynPayload(i_inst->_ref_sock ,i_config,i_payload))
		{
			sock=i_inst->_ref_sock;
		}
	}
	//Listenerのリソースアンロック
	NyLPC_cMutex_unlock(&(i_inst->_mutex));
	return sock;
}




