/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#ifndef NYLPC_CHTTPSHORTHTTPHEADERPARSER_H_
#define NYLPC_CHTTPSHORTHTTPHEADERPARSER_H_
#include "NyLPC_cHttpBasicHeaderParser.h"

/**
 * URLが最大31文字までの、短いHttpリクエストを処理します。
 * このクラスは、NyLPC_TBasicHttpHeader_tにキャストできます。
 */
typedef struct NyLPC_TcHttpShortReqestHeaderParser NyLPC_TcHttpShortRequestHeaderParser_t;


struct NyLPC_THttpShortRequestHeader
{
	struct NyLPC_THttpBasicHeader super;
	NyLPC_TChar url[32];
};

struct NyLPC_TcHttpShortReqestHeaderParser{
	NyLPC_TcHttpBasicHeaderParser_t super;
	NyLPC_TUInt16 url_len;
};

void NyLPC_cHttpShortRequestHeaderParser_initialize(NyLPC_TcHttpShortRequestHeaderParser_t* i_inst);

#define NyLPC_cHttpShortReqestHeaderParser_finalize(i_inst) NyLPC_cHttpBasicHeaderParser_finalize(i_inst);


NyLPC_TBool NyLPC_cHttpShortRequestHeaderParser_parse(NyLPC_TcHttpShortRequestHeaderParser_t* i_inst,NyLPC_TcHttpStream_t* i_stream,struct NyLPC_THttpShortRequestHeader* o_out);


#endif /* NYLPC_CHTTPSHORTHTTPHEADERPARSER_H_ */
