/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.ui;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture2D;

public class Picture
extends Geometry {
    private float width = 1.0f;
    private float height = 1.0f;

    public Picture(String name, boolean flipY) {
        super(name, new Quad(1.0f, 1.0f, flipY));
        this.setQueueBucket(RenderQueue.Bucket.Gui);
        this.setCullHint(Spatial.CullHint.Never);
    }

    public Picture(String name) {
        this(name, false);
    }

    public Picture() {
    }

    public void setWidth(float width) {
        this.width = width;
        this.setLocalScale(new Vector3f(width, this.height, 1.0f));
    }

    public void setHeight(float height) {
        this.height = height;
        this.setLocalScale(new Vector3f(this.width, height, 1.0f));
    }

    public void setPosition(float x, float y) {
        float z = this.getLocalTranslation().getZ();
        this.setLocalTranslation(x, y, z);
    }

    public void setImage(AssetManager assetManager, String imgName, boolean useAlpha) {
        TextureKey key = new TextureKey(imgName, true);
        Texture2D tex = (Texture2D)assetManager.loadTexture(key);
        this.setTexture(assetManager, tex, useAlpha);
    }

    public void setTexture(AssetManager assetManager, Texture2D tex, boolean useAlpha) {
        if (this.getMaterial() == null) {
            Material mat = new Material(assetManager, "Common/MatDefs/Gui/Gui.j3md");
            mat.setColor("Color", ColorRGBA.White);
            this.setMaterial(mat);
        }
        this.material.getAdditionalRenderState().setBlendMode(useAlpha ? RenderState.BlendMode.Alpha : RenderState.BlendMode.Off);
        this.material.setTexture("Texture", tex);
    }
}

