/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.image;

import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.texture.image.ByteAlignedImageCodec;
import com.jme3.texture.image.ByteOffsetImageCodec;
import com.jme3.texture.image.ImageCodec;
import com.jme3.texture.image.ImageRaster;
import java.nio.ByteBuffer;

public class DefaultImageRaster
extends ImageRaster {
    private final int[] components = new int[4];
    private ByteBuffer buffer;
    private final Image image;
    private final ImageCodec codec;
    private final int width;
    private final int height;
    private final byte[] temp;
    private int slice;

    private void rangeCheck(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new IllegalArgumentException("x and y must be inside the image dimensions");
        }
    }

    public DefaultImageRaster(Image image, int slice) {
        this.image = image;
        this.slice = slice;
        this.buffer = image.getData(slice);
        this.codec = ImageCodec.lookup(image.getFormat());
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.temp = (byte[])(this.codec instanceof ByteAlignedImageCodec || this.codec instanceof ByteOffsetImageCodec ? new byte[this.codec.bpp] : null);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setPixel(int x, int y, ColorRGBA color) {
        this.rangeCheck(x, y);
        if (this.codec.isGray) {
            float gray = color.r * 0.27f + color.g * 0.67f + color.b * 0.06f;
            color = new ColorRGBA(gray, gray, gray, color.a);
        }
        switch (this.codec.type) {
            case 1: {
                this.components[0] = FastMath.convertFloatToHalf(color.a);
                this.components[1] = FastMath.convertFloatToHalf(color.r);
                this.components[2] = FastMath.convertFloatToHalf(color.g);
                this.components[3] = FastMath.convertFloatToHalf(color.b);
                break;
            }
            case 2: {
                this.components[0] = Float.floatToIntBits(color.a);
                this.components[1] = Float.floatToIntBits(color.r);
                this.components[2] = Float.floatToIntBits(color.g);
                this.components[3] = Float.floatToIntBits(color.b);
                break;
            }
            case 0: {
                this.components[0] = Math.min((int)(color.a * (float)this.codec.maxAlpha + 0.5f), this.codec.maxAlpha);
                this.components[1] = Math.min((int)(color.r * (float)this.codec.maxRed + 0.5f), this.codec.maxRed);
                this.components[2] = Math.min((int)(color.g * (float)this.codec.maxGreen + 0.5f), this.codec.maxGreen);
                this.components[3] = Math.min((int)(color.b * (float)this.codec.maxBlue + 0.5f), this.codec.maxBlue);
            }
        }
        this.codec.writeComponents(this.getBuffer(), x, y, this.width, this.components, this.temp);
        this.image.setUpdateNeeded();
    }

    private ByteBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = this.image.getData(this.slice);
        }
        return this.buffer;
    }

    public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
        this.rangeCheck(x, y);
        this.codec.readComponents(this.getBuffer(), x, y, this.width, this.components, this.temp);
        if (store == null) {
            store = new ColorRGBA();
        }
        switch (this.codec.type) {
            case 1: {
                store.set(FastMath.convertHalfToFloat((short)this.components[1]), FastMath.convertHalfToFloat((short)this.components[2]), FastMath.convertHalfToFloat((short)this.components[3]), FastMath.convertHalfToFloat((short)this.components[0]));
                break;
            }
            case 2: {
                store.set(Float.intBitsToFloat(this.components[1]), Float.intBitsToFloat(this.components[2]), Float.intBitsToFloat(this.components[3]), Float.intBitsToFloat(this.components[0]));
                break;
            }
            case 0: {
                store.set((float)this.components[1] / (float)this.codec.maxRed, (float)this.components[2] / (float)this.codec.maxGreen, (float)this.components[3] / (float)this.codec.maxBlue, (float)this.components[0] / (float)this.codec.maxAlpha);
            }
        }
        if (this.codec.isGray) {
            store.g = store.b = store.r;
        } else {
            if (this.codec.maxRed == 0) {
                store.r = 1.0f;
            }
            if (this.codec.maxGreen == 0) {
                store.g = 1.0f;
            }
            if (this.codec.maxBlue == 0) {
                store.b = 1.0f;
            }
            if (this.codec.maxAlpha == 0) {
                store.a = 1.0f;
            }
        }
        return store;
    }
}

