/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.asset.Asset;
import com.jme3.asset.AssetKey;
import com.jme3.asset.TextureKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.texture.Image;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Texture
implements Asset,
Savable,
Cloneable {
    private Texture original;
    private String name = null;
    private Image image = null;
    private TextureKey key = null;
    private MinFilter minificationFilter = MinFilter.BilinearNoMipMaps;
    private MagFilter magnificationFilter = MagFilter.Bilinear;
    private ShadowCompareMode shadowCompareMode = ShadowCompareMode.Off;
    private int anisotropicFilter;

    public Texture clone() {
        try {
            return (Texture)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public MinFilter getMinFilter() {
        return this.minificationFilter;
    }

    public void setMinFilter(MinFilter minificationFilter) {
        if (minificationFilter == null) {
            throw new IllegalArgumentException("minificationFilter can not be null.");
        }
        this.minificationFilter = minificationFilter;
    }

    public MagFilter getMagFilter() {
        return this.magnificationFilter;
    }

    public void setMagFilter(MagFilter magnificationFilter) {
        if (magnificationFilter == null) {
            throw new IllegalArgumentException("magnificationFilter can not be null.");
        }
        this.magnificationFilter = magnificationFilter;
    }

    public ShadowCompareMode getShadowCompareMode() {
        return this.shadowCompareMode;
    }

    public void setShadowCompareMode(ShadowCompareMode compareMode) {
        if (compareMode == null) {
            throw new IllegalArgumentException("compareMode can not be null.");
        }
        this.shadowCompareMode = compareMode;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setKey(AssetKey key) {
        this.key = (TextureKey)key;
    }

    public AssetKey getKey() {
        return this.key;
    }

    public Image getImage() {
        return this.image;
    }

    public abstract void setWrap(WrapAxis var1, WrapMode var2);

    public abstract void setWrap(WrapMode var1);

    public abstract WrapMode getWrap(WrapAxis var1);

    public abstract Type getType();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAnisotropicFilter() {
        return this.anisotropicFilter;
    }

    public void setAnisotropicFilter(int level) {
        this.anisotropicFilter = level < 1 ? 1 : level;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[name=").append(this.name);
        if (this.image != null) {
            sb.append(", image=").append(this.image.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Texture other = (Texture)obj;
        if (!(this.image == other.image || this.image != null && this.image.equals(other.image))) {
            return false;
        }
        if (this.minificationFilter != other.minificationFilter) {
            return false;
        }
        if (this.magnificationFilter != other.magnificationFilter) {
            return false;
        }
        if (this.shadowCompareMode != other.shadowCompareMode) {
            return false;
        }
        return this.anisotropicFilter == other.anisotropicFilter;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.image != null ? this.image.hashCode() : 0);
        hash = 67 * hash + (this.minificationFilter != null ? this.minificationFilter.hashCode() : 0);
        hash = 67 * hash + (this.magnificationFilter != null ? this.magnificationFilter.hashCode() : 0);
        hash = 67 * hash + (this.shadowCompareMode != null ? this.shadowCompareMode.hashCode() : 0);
        hash = 67 * hash + this.anisotropicFilter;
        return hash;
    }

    public Texture createSimpleClone(Texture rVal) {
        rVal.setMinFilter(this.minificationFilter);
        rVal.setMagFilter(this.magnificationFilter);
        rVal.setShadowCompareMode(this.shadowCompareMode);
        rVal.setAnisotropicFilter(this.anisotropicFilter);
        rVal.setImage(this.image);
        rVal.setKey(this.key);
        rVal.setName(this.name);
        rVal.original = this.original != null ? this.original : this;
        return rVal;
    }

    public abstract Texture createSimpleClone();

    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.name, "name", null);
        if (this.key == null) {
            capsule.write(this.image, "image", null);
        } else {
            capsule.write(this.key, "key", null);
        }
        capsule.write(this.anisotropicFilter, "anisotropicFilter", 1);
        capsule.write(this.minificationFilter, "minificationFilter", MinFilter.BilinearNoMipMaps);
        capsule.write(this.magnificationFilter, "magnificationFilter", MagFilter.Bilinear);
    }

    public void read(JmeImporter e) throws IOException {
        InputCapsule capsule = e.getCapsule(this);
        this.name = capsule.readString("name", null);
        this.key = (TextureKey)capsule.readSavable("key", null);
        if (this.key != null) {
            Texture loadedTex = e.getAssetManager().loadTexture(this.key);
            if (loadedTex == null) {
                Logger.getLogger(Texture.class.getName()).log(Level.SEVERE, "Could not load texture: {0}", this.key.toString());
            } else {
                this.image = loadedTex.getImage();
            }
        } else {
            this.image = (Image)capsule.readSavable("image", null);
            if (this.image == null) {
                Logger.getLogger(Texture.class.getName()).log(Level.SEVERE, "Could not load embedded image: {0}", this.toString());
            }
        }
        this.anisotropicFilter = capsule.readInt("anisotropicFilter", 1);
        this.minificationFilter = capsule.readEnum("minificationFilter", MinFilter.class, MinFilter.BilinearNoMipMaps);
        this.magnificationFilter = capsule.readEnum("magnificationFilter", MagFilter.class, MagFilter.Bilinear);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShadowCompareMode {
        Off,
        LessOrEqual,
        GreaterOrEqual;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WrapAxis {
        S,
        T,
        R;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WrapMode {
        Repeat,
        MirroredRepeat,
        Clamp,
        MirrorClamp,
        BorderClamp,
        MirrorBorderClamp,
        EdgeClamp,
        MirrorEdgeClamp;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MagFilter {
        Nearest,
        Bilinear;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MinFilter {
        NearestNoMipMaps(false),
        BilinearNoMipMaps(false),
        NearestNearestMipMap(true),
        BilinearNearestMipMap(true),
        NearestLinearMipMap(true),
        Trilinear(true);

        private boolean usesMipMapLevels;

        private MinFilter(boolean usesMipMapLevels) {
            this.usesMipMapLevels = usesMipMapLevels;
        }

        public boolean usesMipMapLevels() {
            return this.usesMipMapLevels;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TwoDimensional,
        TwoDimensionalArray,
        ThreeDimensional,
        CubeMap;

    }
}

