/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.lodcalc.DistanceLodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainLodControl
extends AbstractControl {
    private Terrain terrain;
    private List<Camera> cameras;
    private List<Vector3f> cameraLocations = new ArrayList<Vector3f>();
    private LodCalculator lodCalculator;
    private boolean hasResetLod = false;

    public TerrainLodControl() {
    }

    public TerrainLodControl(Terrain terrain, Camera camera) {
        ArrayList<Camera> cams = new ArrayList<Camera>();
        cams.add(camera);
        this.terrain = terrain;
        this.cameras = cams;
        this.lodCalculator = new DistanceLodCalculator(65, 2.7f);
    }

    public TerrainLodControl(Terrain terrain, List<Camera> cameras) {
        this.terrain = terrain;
        this.cameras = cameras;
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void update(float tpf) {
        this.controlUpdate(tpf);
    }

    @Override
    protected void controlUpdate(float tpf) {
        if (this.lodCalculator == null) {
            return;
        }
        if (!this.enabled && !this.hasResetLod) {
            this.hasResetLod = true;
            this.lodCalculator.turnOffLod();
        }
        if (this.cameras != null) {
            if (this.cameraLocations.isEmpty() && !this.cameras.isEmpty()) {
                for (Camera c : this.cameras) {
                    this.cameraLocations.add(c.getLocation());
                }
            }
            this.terrain.update(this.cameraLocations, this.lodCalculator);
        }
    }

    @Override
    public Control cloneForSpatial(Spatial spatial) {
        if (spatial instanceof Terrain) {
            ArrayList<Camera> cameraClone = new ArrayList<Camera>();
            if (this.cameras != null) {
                for (Camera c : this.cameras) {
                    cameraClone.add(c);
                }
            }
            TerrainLodControl cloned = new TerrainLodControl((Terrain)((Object)spatial), cameraClone);
            cloned.setLodCalculator(this.lodCalculator.clone());
            return cloned;
        }
        return null;
    }

    public void setCamera(Camera camera) {
        ArrayList<Camera> cams = new ArrayList<Camera>();
        cams.add(camera);
        this.setCameras(cams);
    }

    public void setCameras(List<Camera> cameras) {
        this.cameras = cameras;
        this.cameraLocations.clear();
        for (Camera c : cameras) {
            this.cameraLocations.add(c.getLocation());
        }
    }

    @Override
    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        if (spatial instanceof Terrain) {
            this.terrain = (Terrain)((Object)spatial);
        }
    }

    public void setTerrain(Terrain terrain) {
        this.terrain = terrain;
    }

    public LodCalculator getLodCalculator() {
        return this.lodCalculator;
    }

    public void setLodCalculator(LodCalculator lodCalculator) {
        this.lodCalculator = lodCalculator;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.hasResetLod = false;
        } else {
            this.hasResetLod = true;
            this.lodCalculator.turnOnLod();
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write((Node)((Object)this.terrain), "terrain", null);
        oc.write(this.lodCalculator, "lodCalculator", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.terrain = (Terrain)((Object)ic.readSavable("terrain", null));
        this.lodCalculator = (LodCalculator)ic.readSavable("lodCalculator", new DistanceLodCalculator());
    }
}

