/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.animation.Bone;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintDefinitionLocLike
extends ConstraintDefinition {
    private static final int LOCLIKE_X = 1;
    private static final int LOCLIKE_Y = 2;
    private static final int LOCLIKE_Z = 4;
    private static final int LOCLIKE_X_INVERT = 16;
    private static final int LOCLIKE_Y_INVERT = 32;
    private static final int LOCLIKE_Z_INVERT = 64;
    private static final int LOCLIKE_OFFSET = 128;

    public ConstraintDefinitionLocLike(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            int y = this.flag & 2;
            int invY = this.flag & 0x20;
            int z = this.flag & 4;
            int invZ = this.flag & 0x40;
            this.flag &= 0x91;
            this.flag |= y << 1;
            this.flag |= invY << 1;
            this.flag |= z >> 1;
            this.flag |= invZ >> 1;
        }
    }

    public void bake(Transform ownerTransform, Transform targetTransform, float influence) {
        if (this.getOwner() instanceof Bone && ((Bone)this.getOwner()).getParent() != null) {
            return;
        }
        Vector3f ownerLocation = ownerTransform.getTranslation();
        Vector3f targetLocation = targetTransform.getTranslation();
        Vector3f startLocation = ownerTransform.getTranslation().clone();
        Vector3f offset = Vector3f.ZERO;
        if ((this.flag & 0x80) != 0) {
            offset = startLocation;
        }
        if ((this.flag & 1) != 0) {
            ownerLocation.x = targetLocation.x;
            if ((this.flag & 0x10) != 0) {
                ownerLocation.x = -ownerLocation.x;
            }
        }
        if ((this.flag & 2) != 0) {
            ownerLocation.y = targetLocation.y;
            if ((this.flag & 0x20) != 0) {
                ownerLocation.y = -ownerLocation.y;
            }
        }
        if ((this.flag & 4) != 0) {
            ownerLocation.z = targetLocation.z;
            if ((this.flag & 0x40) != 0) {
                ownerLocation.z = -ownerLocation.z;
            }
        }
        ownerLocation.addLocal(offset);
        if (influence < 1.0f) {
            startLocation.subtractLocal(ownerLocation).normalizeLocal().mult(influence);
            ownerLocation.addLocal(startLocation);
        }
    }

    public String getConstraintTypeName() {
        return "Copy location";
    }
}

