/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionDistLimit;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionLocLike;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionLocLimit;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionNull;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionRotLike;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionRotLimit;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionSizeLike;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionSizeLimit;
import com.jme3.scene.plugins.blender.constraints.definitions.UnsupportedConstraintDefinition;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ConstraintDefinitionFactory {
    private static final Map<String, Class<? extends ConstraintDefinition>> CONSTRAINT_CLASSES = new HashMap<String, Class<? extends ConstraintDefinition>>();
    private static final Map<String, String> UNSUPPORTED_CONSTRAINTS;

    public static ConstraintDefinition createConstraintDefinition(Structure constraintStructure, Long ownerOMA, BlenderContext blenderContext) throws BlenderFileException {
        if (constraintStructure == null) {
            return new ConstraintDefinitionNull(null, ownerOMA, blenderContext);
        }
        String constraintClassName = constraintStructure.getType();
        Class<? extends ConstraintDefinition> constraintDefinitionClass = CONSTRAINT_CLASSES.get(constraintClassName);
        if (constraintDefinitionClass != null) {
            try {
                return (ConstraintDefinition)constraintDefinitionClass.getDeclaredConstructors()[0].newInstance(constraintStructure, ownerOMA, blenderContext);
            }
            catch (IllegalArgumentException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (SecurityException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (InstantiationException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
        }
        String constraintName = UNSUPPORTED_CONSTRAINTS.get(constraintClassName);
        if (constraintName != null) {
            return new UnsupportedConstraintDefinition(constraintName);
        }
        throw new BlenderFileException("Unknown constraint type: " + constraintClassName);
    }

    static {
        CONSTRAINT_CLASSES.put("bDistLimitConstraint", ConstraintDefinitionDistLimit.class);
        CONSTRAINT_CLASSES.put("bLocateLikeConstraint", ConstraintDefinitionLocLike.class);
        CONSTRAINT_CLASSES.put("bLocLimitConstraint", ConstraintDefinitionLocLimit.class);
        CONSTRAINT_CLASSES.put("bNullConstraint", ConstraintDefinitionNull.class);
        CONSTRAINT_CLASSES.put("bRotateLikeConstraint", ConstraintDefinitionRotLike.class);
        CONSTRAINT_CLASSES.put("bRotLimitConstraint", ConstraintDefinitionRotLimit.class);
        CONSTRAINT_CLASSES.put("bSizeLikeConstraint", ConstraintDefinitionSizeLike.class);
        CONSTRAINT_CLASSES.put("bSizeLimitConstraint", ConstraintDefinitionSizeLimit.class);
        UNSUPPORTED_CONSTRAINTS = new HashMap<String, String>();
        UNSUPPORTED_CONSTRAINTS.put("bActionConstraint", "Action");
        UNSUPPORTED_CONSTRAINTS.put("bChildOfConstraint", "Child of");
        UNSUPPORTED_CONSTRAINTS.put("bClampToConstraint", "Clamp to");
        UNSUPPORTED_CONSTRAINTS.put("bFollowPathConstraint", "Follow path");
        UNSUPPORTED_CONSTRAINTS.put("bKinematicConstraint", "Inverse kinematic");
        UNSUPPORTED_CONSTRAINTS.put("bLockTrackConstraint", "Lock track");
        UNSUPPORTED_CONSTRAINTS.put("bMinMaxConstraint", "Min max");
        UNSUPPORTED_CONSTRAINTS.put("bPythonConstraint", "Python/Script");
        UNSUPPORTED_CONSTRAINTS.put("bRigidBodyJointConstraint", "Rigid body joint");
        UNSUPPORTED_CONSTRAINTS.put("bShrinkWrapConstraint", "Shrinkwrap");
        UNSUPPORTED_CONSTRAINTS.put("bStretchToConstraint", "Stretch to");
        UNSUPPORTED_CONSTRAINTS.put("bTransformConstraint", "Transform");
        UNSUPPORTED_CONSTRAINTS.put("bSplineIKConstraint", "Spline inverse kinematics");
        UNSUPPORTED_CONSTRAINTS.put("bDampTrackConstraint", "Damp track");
        UNSUPPORTED_CONSTRAINTS.put("bPivotConstraint", "Pivot");
        UNSUPPORTED_CONSTRAINTS.put("bTrackToConstraint", "Track to");
        UNSUPPORTED_CONSTRAINTS.put("bSameVolumeConstraint", "Same volume");
        UNSUPPORTED_CONSTRAINTS.put("bTransLikeConstraint", "Trans like");
        UNSUPPORTED_CONSTRAINTS.put("bCameraSolverConstraint", "Camera solver");
        UNSUPPORTED_CONSTRAINTS.put("bObjectSolverConstraint", "Object solver");
        UNSUPPORTED_CONSTRAINTS.put("bFollowTrackConstraint", "Follow track");
    }
}

