/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.constraints.BoneConstraint;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.SimulationNode;
import com.jme3.scene.plugins.blender.constraints.SkeletonConstraint;
import com.jme3.scene.plugins.blender.constraints.SpatialConstraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConstraintHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ConstraintHelper.class.getName());
    private static final Quaternion POS_POSE_SPACE_QUATERNION = new Quaternion(new float[]{(float)Math.PI, 0.0f, 0.0f});
    private static final Quaternion NEG_POSE_SPACE_QUATERNION = new Quaternion(new float[]{(float)(-Math.PI), 0.0f, 0.0f});
    private static final Quaternion POS_PARLOC_SPACE_QUATERNION = new Quaternion(new float[]{1.5707964f, 0.0f, 0.0f});
    private static final Quaternion NEG_PARLOC_SPACE_QUATERNION = new Quaternion(new float[]{-1.5707964f, 0.0f, 0.0f});

    public ConstraintHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public void loadConstraints(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        List<Structure> constraints;
        ArrayList<Constraint> constraintsList;
        Pointer pPose;
        LOGGER.fine("Loading constraints.");
        IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
        HashMap constraintsIpos = new HashMap();
        Pointer pActions = (Pointer)objectStructure.getFieldValue("action");
        if (pActions.isNotNull()) {
            List<Structure> actions = pActions.fetchData(blenderContext.getInputStream());
            for (Structure action : actions) {
                Structure chanbase = (Structure)action.getFieldValue("chanbase");
                List<Structure> actionChannels = chanbase.evaluateListBase(blenderContext);
                for (Structure actionChannel : actionChannels) {
                    HashMap<String, Ipo> ipos = new HashMap<String, Ipo>();
                    Structure constChannels = (Structure)actionChannel.getFieldValue("constraintChannels");
                    List<Structure> constraintChannels = constChannels.evaluateListBase(blenderContext);
                    for (Structure constraintChannel : constraintChannels) {
                        Pointer pIpo = (Pointer)constraintChannel.getFieldValue("ipo");
                        if (!pIpo.isNotNull()) continue;
                        String constraintName = constraintChannel.getFieldValue("name").toString();
                        Ipo ipo = ipoHelper.fromIpoStructure(pIpo.fetchData(blenderContext.getInputStream()).get(0), blenderContext);
                        ipos.put(constraintName, ipo);
                    }
                    String actionName = actionChannel.getFieldValue("name").toString();
                    constraintsIpos.put(actionName, ipos);
                }
            }
        }
        if ((pPose = (Pointer)objectStructure.getFieldValue("pose")).isNotNull()) {
            List<Structure> poseChannels = ((Structure)pPose.fetchData(blenderContext.getInputStream()).get(0).getFieldValue("chanbase")).evaluateListBase(blenderContext);
            for (Structure poseChannel : poseChannels) {
                constraintsList = new ArrayList<Constraint>();
                Long boneOMA = ((Pointer)poseChannel.getFieldValue("bone")).getOldMemoryAddress();
                String name = blenderContext.getFileBlock(boneOMA).getStructure(blenderContext).getFieldValue("name").toString();
                List<Structure> constraints2 = ((Structure)poseChannel.getFieldValue("constraints")).evaluateListBase(blenderContext);
                for (Structure constraint : constraints2) {
                    Ipo ipo;
                    String constraintName = constraint.getFieldValue("name").toString();
                    Map ipoMap = (Map)constraintsIpos.get(name);
                    Ipo ipo2 = ipo = ipoMap == null ? null : (Ipo)ipoMap.get(constraintName);
                    if (ipo == null) {
                        float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                        ipo = ipoHelper.fromValue(enforce);
                    }
                    constraintsList.add(new BoneConstraint(constraint, boneOMA, ipo, blenderContext));
                }
                blenderContext.addConstraints(boneOMA, constraintsList);
            }
        }
        if ((constraints = ((Structure)objectStructure.getFieldValue("constraints")).evaluateListBase(blenderContext)) != null && constraints.size() > 0) {
            Pointer pData = (Pointer)objectStructure.getFieldValue("data");
            String dataType = pData.isNotNull() ? pData.fetchData(blenderContext.getInputStream()).get(0).getType() : null;
            constraintsList = new ArrayList(constraints.size());
            for (Structure constraint : constraints) {
                Ipo ipo;
                String constraintName = constraint.getFieldValue("name").toString();
                String objectName = objectStructure.getName();
                Map objectConstraintsIpos = (Map)constraintsIpos.get(objectName);
                Ipo ipo3 = ipo = objectConstraintsIpos != null ? (Ipo)objectConstraintsIpos.get(constraintName) : null;
                if (ipo == null) {
                    float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                    ipo = ipoHelper.fromValue(enforce);
                }
                constraintsList.add(this.createConstraint(dataType, constraint, objectStructure.getOldMemoryAddress(), ipo, blenderContext));
            }
            blenderContext.addConstraints(objectStructure.getOldMemoryAddress(), constraintsList);
        }
    }

    private Constraint createConstraint(String dataType, Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        if (dataType == null || "Mesh".equalsIgnoreCase(dataType) || "Camera".equalsIgnoreCase(dataType) || "Lamp".equalsIgnoreCase(dataType)) {
            return new SpatialConstraint(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        }
        if ("Armature".equalsIgnoreCase(dataType)) {
            return new SkeletonConstraint(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        }
        throw new IllegalArgumentException("Unsupported data type for applying constraints: " + dataType);
    }

    public void bakeConstraints(BlenderContext blenderContext) {
        ArrayList<SimulationNode> simulationRootNodes = new ArrayList<SimulationNode>();
        for (Constraint constraint : blenderContext.getAllConstraints()) {
            boolean constraintUsed = false;
            for (SimulationNode node : simulationRootNodes) {
                if (!node.contains(constraint)) continue;
                constraintUsed = true;
                break;
            }
            if (constraintUsed) continue;
            if (constraint instanceof BoneConstraint) {
                BoneContext boneContext = blenderContext.getBoneContext(constraint.ownerOMA);
                simulationRootNodes.add(new SimulationNode(boneContext.getArmatureObjectOMA(), blenderContext));
                continue;
            }
            if (constraint instanceof SpatialConstraint) {
                Spatial spatial = (Spatial)blenderContext.getLoadedFeature(constraint.ownerOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
                while (spatial.getParent() != null) {
                    spatial = spatial.getParent();
                }
                simulationRootNodes.add(new SimulationNode((Long)blenderContext.getMarkerValue("oma", spatial), blenderContext));
                continue;
            }
            throw new IllegalStateException("Unsupported constraint type: " + constraint);
        }
        for (SimulationNode node : simulationRootNodes) {
            node.simulate();
        }
    }

    public Transform getTransform(Long oma, String subtargetName, Space space) {
        boolean isArmature;
        Spatial feature = (Spatial)this.blenderContext.getLoadedFeature(oma, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        boolean bl = isArmature = this.blenderContext.getMarkerValue("armature-node", feature) != null;
        if (isArmature) {
            BoneContext targetBoneContext = this.blenderContext.getBoneByName(subtargetName);
            Bone bone = targetBoneContext.getBone();
            switch (space) {
                case CONSTRAINT_SPACE_WORLD: {
                    return new Transform(bone.getModelSpacePosition(), bone.getModelSpaceRotation(), bone.getModelSpaceScale());
                }
                case CONSTRAINT_SPACE_LOCAL: {
                    Transform localTransform = new Transform(bone.getLocalPosition(), bone.getLocalRotation());
                    localTransform.setScale(bone.getLocalScale());
                    return localTransform;
                }
                case CONSTRAINT_SPACE_POSE: {
                    Node nodeWithAnimationControl = this.blenderContext.getControlledNode(targetBoneContext.getSkeleton());
                    Matrix4f m = this.toMatrix(nodeWithAnimationControl.getWorldTransform());
                    Matrix4f boneAgainstModifiedNodeMatrix = this.toMatrix(bone.getLocalPosition(), bone.getLocalRotation(), bone.getLocalScale());
                    Matrix4f boneWorldMatrix = m.multLocal(boneAgainstModifiedNodeMatrix);
                    Matrix4f armatureWorldMatrix = this.toMatrix(feature.getWorldTransform()).invertLocal();
                    Matrix4f r2 = armatureWorldMatrix.multLocal(boneWorldMatrix);
                    Vector3f loc2 = r2.toTranslationVector();
                    Quaternion rot2 = r2.toRotationQuat().normalizeLocal().multLocal(POS_POSE_SPACE_QUATERNION);
                    Vector3f scl2 = r2.toScaleVector();
                    return new Transform(loc2, rot2, scl2);
                }
                case CONSTRAINT_SPACE_PARLOCAL: {
                    Matrix4f parentLocalMatrix = Matrix4f.IDENTITY;
                    if (bone.getParent() != null) {
                        Bone parent = bone.getParent();
                        parentLocalMatrix = this.toMatrix(parent.getLocalPosition(), parent.getLocalRotation(), parent.getLocalScale());
                    } else {
                        parentLocalMatrix = parentLocalMatrix.clone();
                    }
                    Matrix4f boneLocalMatrix = this.toMatrix(bone.getLocalPosition(), bone.getLocalRotation(), bone.getLocalScale());
                    Matrix4f result = parentLocalMatrix.multLocal(boneLocalMatrix);
                    Vector3f loc = result.toTranslationVector();
                    Quaternion rot = result.toRotationQuat().normalizeLocal().multLocal(NEG_PARLOC_SPACE_QUATERNION);
                    Vector3f scl = result.toScaleVector();
                    return new Transform(loc, rot, scl);
                }
            }
            throw new IllegalStateException("Unknown space type: " + (Object)((Object)space));
        }
        switch (space) {
            case CONSTRAINT_SPACE_LOCAL: {
                return feature.getLocalTransform();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return feature.getWorldTransform();
            }
            case CONSTRAINT_SPACE_POSE: 
            case CONSTRAINT_SPACE_PARLOCAL: {
                throw new IllegalStateException("Nodes can have only Local and World spaces applied!");
            }
        }
        throw new IllegalStateException("Unknown space type: " + (Object)((Object)space));
    }

    public void applyTransform(Long oma, String subtargetName, Space space, Transform transform) {
        boolean isArmature;
        Spatial feature = (Spatial)this.blenderContext.getLoadedFeature(oma, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        boolean bl = isArmature = this.blenderContext.getMarkerValue("armature-node", feature) != null;
        if (isArmature) {
            Skeleton skeleton = this.blenderContext.getSkeleton(oma);
            BoneContext targetBoneContext = this.blenderContext.getBoneByName(subtargetName);
            Bone bone = targetBoneContext.getBone();
            Node nodeControlledBySkeleton = this.blenderContext.getControlledNode(skeleton);
            Transform nodeTransform = nodeControlledBySkeleton.getWorldTransform();
            Matrix4f invertedNodeMatrix = this.toMatrix(nodeTransform).invertLocal();
            switch (space) {
                case CONSTRAINT_SPACE_LOCAL: {
                    bone.setBindTransforms(transform.getTranslation(), transform.getRotation(), transform.getScale());
                    break;
                }
                case CONSTRAINT_SPACE_WORLD: {
                    Matrix4f boneMatrix = this.toMatrix(transform);
                    Bone parent = bone.getParent();
                    if (parent != null) {
                        Matrix4f invertedParentWorldMatrix = this.toMatrix(parent.getModelSpacePosition(), parent.getModelSpaceRotation(), parent.getModelSpaceScale()).invertLocal();
                        boneMatrix = invertedParentWorldMatrix.multLocal(boneMatrix);
                    }
                    boneMatrix = invertedNodeMatrix.multLocal(boneMatrix);
                    bone.setBindTransforms(boneMatrix.toTranslationVector(), boneMatrix.toRotationQuat(), boneMatrix.toScaleVector());
                    break;
                }
                case CONSTRAINT_SPACE_POSE: {
                    Matrix4f armatureWorldMatrix = this.toMatrix(feature.getWorldTransform());
                    Matrix4f bonePoseMatrix = this.toMatrix(transform);
                    Matrix4f boneWorldMatrix = armatureWorldMatrix.multLocal(bonePoseMatrix);
                    Matrix4f boneLocalMatrix = invertedNodeMatrix.multLocal(boneWorldMatrix);
                    Vector3f loc2 = boneLocalMatrix.toTranslationVector();
                    Quaternion rot2 = boneLocalMatrix.toRotationQuat().normalizeLocal().multLocal(new Quaternion(NEG_POSE_SPACE_QUATERNION));
                    Vector3f scl2 = boneLocalMatrix.toScaleVector();
                    bone.setBindTransforms(loc2, rot2, scl2);
                    break;
                }
                case CONSTRAINT_SPACE_PARLOCAL: {
                    Matrix4f parentLocalMatrix = Matrix4f.IDENTITY;
                    if (bone.getParent() != null) {
                        parentLocalMatrix = this.toMatrix(bone.getParent().getLocalPosition(), bone.getParent().getLocalRotation(), bone.getParent().getLocalScale());
                        parentLocalMatrix.invertLocal();
                    } else {
                        parentLocalMatrix = parentLocalMatrix.clone();
                    }
                    Matrix4f m = this.toMatrix(transform.getTranslation(), transform.getRotation(), transform.getScale());
                    Matrix4f result = parentLocalMatrix.multLocal(m);
                    Vector3f loc = result.toTranslationVector();
                    Quaternion rot = result.toRotationQuat().normalizeLocal().multLocal(POS_PARLOC_SPACE_QUATERNION);
                    Vector3f scl = result.toScaleVector();
                    bone.setBindTransforms(loc, rot, scl);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid space type for target object: " + space.toString());
                }
            }
        } else {
            switch (space) {
                case CONSTRAINT_SPACE_LOCAL: {
                    feature.getLocalTransform().set(transform);
                    break;
                }
                case CONSTRAINT_SPACE_WORLD: {
                    if (feature.getParent() == null) {
                        feature.setLocalTransform(transform);
                        break;
                    }
                    Transform parentWorldTransform = feature.getParent().getWorldTransform();
                    Matrix4f parentMatrix = this.toMatrix(parentWorldTransform).invertLocal();
                    Matrix4f m = this.toMatrix(transform);
                    m = m.multLocal(parentMatrix);
                    transform.setTranslation(m.toTranslationVector());
                    transform.setRotation(m.toRotationQuat());
                    transform.setScale(m.toScaleVector());
                    feature.setLocalTransform(transform);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid space type for spatial object: " + space.toString());
                }
            }
        }
    }

    private Matrix4f toMatrix(Transform transform) {
        Matrix4f result = Matrix4f.IDENTITY;
        if (transform != null) {
            result = this.toMatrix(transform.getTranslation(), transform.getRotation(), transform.getScale());
        }
        return result;
    }

    private Matrix4f toMatrix(Vector3f position, Quaternion rotation, Vector3f scale) {
        Matrix4f result = new Matrix4f();
        result.setTranslation(position);
        result.setRotationQuaternion(rotation);
        result.setScale(scale);
        return result;
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Space {
        CONSTRAINT_SPACE_WORLD,
        CONSTRAINT_SPACE_LOCAL,
        CONSTRAINT_SPACE_POSE,
        CONSTRAINT_SPACE_PARLOCAL;


        public static Space valueOf(byte c) {
            switch (c) {
                case 0: {
                    return CONSTRAINT_SPACE_WORLD;
                }
                case 1: {
                    return CONSTRAINT_SPACE_LOCAL;
                }
                case 2: {
                    return CONSTRAINT_SPACE_POSE;
                }
                case 3: {
                    return CONSTRAINT_SPACE_PARLOCAL;
                }
            }
            throw new IllegalArgumentException("Value: " + c + " cannot be converted to Space enum instance!");
        }
    }
}

