/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.Image;

public class CartoonEdgeFilter
extends Filter {
    private Filter.Pass normalPass;
    private float edgeWidth = 1.0f;
    private float edgeIntensity = 1.0f;
    private float normalThreshold = 0.5f;
    private float depthThreshold = 0.1f;
    private float normalSensitivity = 1.0f;
    private float depthSensitivity = 10.0f;
    private ColorRGBA edgeColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private RenderManager renderManager;
    private ViewPort viewPort;

    public CartoonEdgeFilter() {
        super("CartoonEdgeFilter");
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected void postQueue(RenderQueue queue) {
        Renderer r = this.renderManager.getRenderer();
        r.setFrameBuffer(this.normalPass.getRenderFrameBuffer());
        this.renderManager.getRenderer().clearBuffers(true, true, true);
        this.renderManager.setForcedTechnique("PreNormalPass");
        this.renderManager.renderViewPortQueues(this.viewPort, false);
        this.renderManager.setForcedTechnique(null);
        this.renderManager.getRenderer().setFrameBuffer(this.viewPort.getOutputFrameBuffer());
    }

    protected Material getMaterial() {
        this.material.setTexture("NormalsTexture", this.normalPass.getRenderedTexture());
        return this.material;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.renderManager = renderManager;
        this.viewPort = vp;
        this.normalPass = new Filter.Pass();
        this.normalPass.init(renderManager.getRenderer(), w, h, Image.Format.RGBA8, Image.Format.Depth);
        this.material = new Material(manager, "Common/MatDefs/Post/CartoonEdge.j3md");
        this.material.setFloat("EdgeWidth", this.edgeWidth);
        this.material.setFloat("EdgeIntensity", this.edgeIntensity);
        this.material.setFloat("NormalThreshold", this.normalThreshold);
        this.material.setFloat("DepthThreshold", this.depthThreshold);
        this.material.setFloat("NormalSensitivity", this.normalSensitivity);
        this.material.setFloat("DepthSensitivity", this.depthSensitivity);
        this.material.setColor("EdgeColor", this.edgeColor);
    }

    public float getDepthSensitivity() {
        return this.depthSensitivity;
    }

    public void setDepthSensitivity(float depthSensitivity) {
        this.depthSensitivity = depthSensitivity;
        if (this.material != null) {
            this.material.setFloat("DepthSensitivity", depthSensitivity);
        }
    }

    public float getDepthThreshold() {
        return this.depthThreshold;
    }

    public void setDepthThreshold(float depthThreshold) {
        this.depthThreshold = depthThreshold;
        if (this.material != null) {
            this.material.setFloat("DepthThreshold", depthThreshold);
        }
    }

    public float getEdgeIntensity() {
        return this.edgeIntensity;
    }

    public void setEdgeIntensity(float edgeIntensity) {
        this.edgeIntensity = edgeIntensity;
        if (this.material != null) {
            this.material.setFloat("EdgeIntensity", edgeIntensity);
        }
    }

    public float getEdgeWidth() {
        return this.edgeWidth;
    }

    public void setEdgeWidth(float edgeWidth) {
        this.edgeWidth = edgeWidth;
        if (this.material != null) {
            this.material.setFloat("EdgeWidth", edgeWidth);
        }
    }

    public float getNormalSensitivity() {
        return this.normalSensitivity;
    }

    public void setNormalSensitivity(float normalSensitivity) {
        this.normalSensitivity = normalSensitivity;
        if (this.material != null) {
            this.material.setFloat("NormalSensitivity", normalSensitivity);
        }
    }

    public float getNormalThreshold() {
        return this.normalThreshold;
    }

    public void setNormalThreshold(float normalThreshold) {
        this.normalThreshold = normalThreshold;
        if (this.material != null) {
            this.material.setFloat("NormalThreshold", normalThreshold);
        }
    }

    public ColorRGBA getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(ColorRGBA edgeColor) {
        this.edgeColor = edgeColor;
        if (this.material != null) {
            this.material.setColor("EdgeColor", edgeColor);
        }
    }
}

