/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.Client;
import com.jme3.network.ClientStateListener;
import com.jme3.network.ErrorListener;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.base.ConnectorAdapter;
import com.jme3.network.base.MessageListenerRegistry;
import com.jme3.network.base.MessageProtocol;
import com.jme3.network.kernel.Connector;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClient
implements Client {
    static Logger log = Logger.getLogger(DefaultClient.class.getName());
    private ThreadLocal<ByteBuffer> dataBuffer = new ThreadLocal();
    private int id = -1;
    private boolean isRunning = false;
    private CountDownLatch connecting = new CountDownLatch(1);
    private String gameName;
    private int version;
    private Connector reliable;
    private Connector fast;
    private MessageListenerRegistry<Client> messageListeners = new MessageListenerRegistry();
    private List<ClientStateListener> stateListeners = new CopyOnWriteArrayList<ClientStateListener>();
    private List<ErrorListener<? super Client>> errorListeners = new CopyOnWriteArrayList<ErrorListener<? super Client>>();
    private Redispatch dispatcher = new Redispatch();
    private ConnectorAdapter reliableAdapter;
    private ConnectorAdapter fastAdapter;

    public DefaultClient(String gameName, int version) {
        this.gameName = gameName;
        this.version = version;
    }

    public DefaultClient(String gameName, int version, Connector reliable, Connector fast) {
        this(gameName, version);
        this.setConnectors(reliable, fast);
    }

    protected void setConnectors(Connector reliable, Connector fast) {
        if (reliable == null) {
            throw new IllegalArgumentException("The reliable connector cannot be null.");
        }
        if (this.isRunning) {
            throw new IllegalStateException("Client is already started.");
        }
        this.reliable = reliable;
        this.fast = fast;
        this.reliableAdapter = new ConnectorAdapter(reliable, this.dispatcher, this.dispatcher, true);
        if (fast != null) {
            this.fastAdapter = new ConnectorAdapter(fast, this.dispatcher, this.dispatcher, false);
        }
    }

    protected void checkRunning() {
        if (!this.isRunning) {
            throw new IllegalStateException("Client is not started.");
        }
    }

    @Override
    public void start() {
        ClientRegistrationMessage reg;
        if (this.isRunning) {
            throw new IllegalStateException("Client is already started.");
        }
        if (this.reliableAdapter != null) {
            this.reliableAdapter.start();
        }
        if (this.fastAdapter != null) {
            this.fastAdapter.start();
        }
        long tempId = System.currentTimeMillis() + System.nanoTime();
        this.isRunning = true;
        if (this.reliable != null) {
            reg = new ClientRegistrationMessage();
            reg.setId(tempId);
            reg.setGameName(this.getGameName());
            reg.setVersion(this.getVersion());
            reg.setReliable(true);
            this.send(reg, false);
        }
        if (this.fast != null) {
            reg = new ClientRegistrationMessage();
            reg.setId(tempId);
            reg.setReliable(false);
            this.send(reg, false);
        }
    }

    protected void waitForConnected() {
        if (this.isConnected()) {
            return;
        }
        try {
            this.connecting.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for connect", e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.id != -1 && this.isRunning;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getGameName() {
        return this.gameName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void send(Message message) {
        this.send(message, true);
    }

    protected void send(Message message, boolean waitForConnected) {
        ByteBuffer buffer;
        this.checkRunning();
        if (waitForConnected) {
            this.waitForConnected();
        }
        if ((buffer = this.dataBuffer.get()) == null) {
            buffer = ByteBuffer.allocate(65538);
            this.dataBuffer.set(buffer);
        }
        buffer.clear();
        buffer = MessageProtocol.messageToBuffer(message, buffer);
        byte[] temp = new byte[buffer.remaining()];
        System.arraycopy(buffer.array(), buffer.position(), temp, 0, buffer.remaining());
        buffer = ByteBuffer.wrap(temp);
        if (message.isReliable() || this.fast == null) {
            if (this.reliable == null) {
                throw new RuntimeException("No reliable connector configured");
            }
            this.reliableAdapter.write(buffer);
        } else {
            this.fastAdapter.write(buffer);
        }
    }

    @Override
    public void close() {
        this.checkRunning();
        this.closeConnections(null);
    }

    protected void closeConnections(ClientStateListener.DisconnectInfo info) {
        if (!this.isRunning) {
            return;
        }
        if (this.fastAdapter != null) {
            this.fastAdapter.close();
        }
        if (this.reliableAdapter != null) {
            this.reliableAdapter.close();
        }
        this.connecting.countDown();
        this.fireDisconnected(info);
        this.isRunning = false;
    }

    @Override
    public void addClientStateListener(ClientStateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeClientStateListener(ClientStateListener listener) {
        this.stateListeners.remove(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super Client> listener) {
        this.messageListeners.addMessageListener(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super Client> listener, Class ... classes) {
        this.messageListeners.addMessageListener(listener, classes);
    }

    @Override
    public void removeMessageListener(MessageListener<? super Client> listener) {
        this.messageListeners.removeMessageListener(listener);
    }

    @Override
    public void removeMessageListener(MessageListener<? super Client> listener, Class ... classes) {
        this.messageListeners.removeMessageListener(listener, classes);
    }

    @Override
    public void addErrorListener(ErrorListener<? super Client> listener) {
        this.errorListeners.add(listener);
    }

    @Override
    public void removeErrorListener(ErrorListener<? super Client> listener) {
        this.errorListeners.remove(listener);
    }

    protected void fireConnected() {
        for (ClientStateListener l : this.stateListeners) {
            l.clientConnected(this);
        }
    }

    protected void fireDisconnected(ClientStateListener.DisconnectInfo info) {
        for (ClientStateListener l : this.stateListeners) {
            l.clientDisconnected(this, info);
        }
    }

    protected void handleError(Throwable t) {
        if (this.errorListeners.isEmpty()) {
            log.log(Level.SEVERE, "Termining connection due to unhandled error", t);
            ClientStateListener.DisconnectInfo info = new ClientStateListener.DisconnectInfo();
            info.reason = "Connection Error";
            info.error = t;
            this.closeConnections(info);
            return;
        }
        for (ErrorListener<? super Client> l : this.errorListeners) {
            l.handleError(this, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(Message m) {
        if (m instanceof ClientRegistrationMessage) {
            this.id = (int)((ClientRegistrationMessage)m).getId();
            log.log(Level.INFO, "Connection established, id:{0}.", this.id);
            this.connecting.countDown();
            this.fireConnected();
            return;
        }
        if (m instanceof DisconnectMessage) {
            String reason = ((DisconnectMessage)m).getReason();
            log.log(Level.SEVERE, "Connection terminated, reason:{0}.", reason);
            ClientStateListener.DisconnectInfo info = new ClientStateListener.DisconnectInfo();
            info.reason = reason;
            this.closeConnections(info);
        }
        DefaultClient defaultClient = this;
        synchronized (defaultClient) {
            this.messageListeners.messageReceived(this, m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Redispatch
    implements MessageListener<Object>,
    ErrorListener<Object> {
        protected Redispatch() {
        }

        @Override
        public void messageReceived(Object source, Message m) {
            DefaultClient.this.dispatch(m);
        }

        @Override
        public void handleError(Object source, Throwable t) {
            DefaultClient.this.handleError(t);
        }
    }
}

