/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.Texture3D;
import com.jme3.texture.TextureCubeMap;
import java.io.IOException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureKey
extends AssetKey<Texture> {
    private boolean generateMips;
    private boolean flipY;
    private boolean asCube;
    private boolean asTexture3D;
    private int anisotropy;
    private Texture.Type textureTypeHint = Texture.Type.TwoDimensional;

    public TextureKey(String name, boolean flipY) {
        super(name);
        this.flipY = flipY;
    }

    public TextureKey(String name) {
        super(name);
        this.flipY = true;
    }

    public TextureKey() {
    }

    @Override
    public String toString() {
        return this.name + (this.flipY ? " (Flipped)" : "") + (this.asCube ? " (Cube)" : "") + (this.generateMips ? " (Mipmaped)" : "");
    }

    @Override
    public boolean useSmartCache() {
        return true;
    }

    @Override
    public Object createClonedInstance(Object asset) {
        Texture tex = (Texture)asset;
        return tex.createSimpleClone();
    }

    @Override
    public Object postProcess(Object asset) {
        Texture tex;
        Image img = (Image)asset;
        if (img == null) {
            return null;
        }
        if (this.isAsCube()) {
            if (this.isFlipY()) {
                ByteBuffer pos_y = img.getData(2);
                img.setData(2, img.getData(3));
                img.setData(3, pos_y);
            }
            tex = new TextureCubeMap();
        } else {
            tex = this.isAsTexture3D() ? new Texture3D() : new Texture2D();
        }
        if (img.hasMipmaps() || this.isGenerateMips()) {
            tex.setMinFilter(Texture.MinFilter.Trilinear);
        }
        tex.setAnisotropicFilter(this.getAnisotropy());
        tex.setName(this.getName());
        tex.setImage(img);
        return tex;
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public int getAnisotropy() {
        return this.anisotropy;
    }

    public void setAnisotropy(int anisotropy) {
        this.anisotropy = anisotropy;
    }

    public boolean isAsCube() {
        return this.asCube;
    }

    public void setAsCube(boolean asCube) {
        this.asCube = asCube;
    }

    public boolean isGenerateMips() {
        return this.generateMips;
    }

    public void setGenerateMips(boolean generateMips) {
        this.generateMips = generateMips;
    }

    public boolean isAsTexture3D() {
        return this.asTexture3D;
    }

    public void setAsTexture3D(boolean asTexture3D) {
        this.asTexture3D = asTexture3D;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TextureKey)) {
            return false;
        }
        return super.equals(other) && this.isFlipY() == ((TextureKey)other).isFlipY();
    }

    public Texture.Type getTextureTypeHint() {
        return this.textureTypeHint;
    }

    public void setTextureTypeHint(Texture.Type textureTypeHint) {
        this.textureTypeHint = textureTypeHint;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.flipY, "flip_y", false);
        oc.write(this.generateMips, "generate_mips", false);
        oc.write(this.asCube, "as_cubemap", false);
        oc.write(this.anisotropy, "anisotropy", 0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.flipY = ic.readBoolean("flip_y", false);
        this.generateMips = ic.readBoolean("generate_mips", false);
        this.asCube = ic.readBoolean("as_cubemap", false);
        this.anisotropy = ic.readInt("anisotropy", 0);
    }
}

