/*
 * Copyright (c) 2003, jMonkeyEngine - Mojo Monkey Coding
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer. 
 * 
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 
 * Neither the name of the Mojo Monkey Coding, jME, jMonkey Engine, nor the 
 * names of its contributors may be used to endorse or promote products derived 
 * from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package jme.controller;

import jme.math.Vector;


/**
 * <code>EntityController</code> defines an interface for interacting with 
 * an entity. An entity can be a game object such as a character running
 * around the world or a Entity where the Entity is a means for defining the 
 * view port of the display. 
 * 
 * @author Mark Powell
 * @version 0.1.0
 */
public interface EntityController {
    
    /**
     * <code>getEntityPosition</code> returns the current location in 
     * three dimensional space of the Entity.
     * 
     * @return the position of the Entity.
     */
    public Vector getEntityPosition();
    
    /**
     * <code>setEntityPosition</code> sets the position of the Entity to the
     * vector passed.
     * 
     * @param position the new position of the Entity.
     */
    public void setEntityPosition(Vector position);
    
    /**
     * <code>setEntityYaw</code> sets the yaw angle of the entity. Where yaw is
     * defined as rotation about the local Y axis.
     * @param angle the angle of yaw.
     */
    public void setEntityYaw(float angle);
	/**
	 * <code>setEntityRoll</code> sets the roll angle of the entity. Where roll
	 * is defined as rotation about the local Z axis.
	 * @param angle the angle of roll.
	 */
    public void setEntityRoll(float angle);
    
	/**
	 * <code>setEntityPitch</code> sets the pitch angle of the entity. Where 
	 * pitch is defined as rotation about the local x axis.
	 * @param angle the angle of pitch.
	 */
    public void setEntityPitch(float angle);
    
    /**
     * <code>render</code> sets the model view matrix to that defined by the
     * Entity's position, view and up vectors. 
     */    
    public void render();
}
