/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal.eax;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.Sys;
import org.lwjgl.openal.eax.CoreEAX;
import org.lwjgl.openal.eax.EAX;

public class EAXBufferProperties {
    protected ByteBuffer eaxBufferProperties = ByteBuffer.allocateDirect(EAXBUFFERPROPERTIES_SIZE);
    protected static int EAXBUFFERPROPERTIES_SIZE;
    protected static int direct_offset;
    protected static int directHF_offset;
    protected static int room_offset;
    protected static int roomHF_offset;
    protected static int roomRolloffFactor_offset;
    protected static int obstruction_offset;
    protected static int obstructionLFRatio_offset;
    protected static int occlusion_offset;
    protected static int occlusionLFRatio_offset;
    protected static int occlusionRoomRatio_offset;
    protected static int outsideVolumeHF_offset;
    protected static int airAbsorptionFactor_offset;
    protected static int flags_offset;
    public static final int EAXBUFFER_NONE = 0;
    public static final int EAXBUFFER_ALLPARAMETERS = 1;
    public static final int EAXBUFFER_DIRECT = 2;
    public static final int EAXBUFFER_DIRECTHF = 3;
    public static final int EAXBUFFER_ROOM = 4;
    public static final int EAXBUFFER_ROOMHF = 5;
    public static final int EAXBUFFER_ROOMROLLOFFFACTOR = 6;
    public static final int EAXBUFFER_OBSTRUCTION = 7;
    public static final int EAXBUFFER_OBSTRUCTIONLFRATIO = 8;
    public static final int EAXBUFFER_OCCLUSION = 9;
    public static final int EAXBUFFER_OCCLUSIONLFRATIO = 10;
    public static final int EAXBUFFER_OCCLUSIONROOMRATIO = 11;
    public static final int EAXBUFFER_OUTSIDEVOLUMEHF = 12;
    public static final int EAXBUFFER_AIRABSORPTIONFACTOR = 13;
    public static final int EAXBUFFER_FLAGS = 14;
    public static final int EAXBUFFER_IMMEDIATE = 0;
    public static final int EAXBUFFER_DEFERRED = Integer.MIN_VALUE;
    public static final int EAXBUFFER_COMMITDEFERREDSETTINGS = 0;
    public static final int EAXBUFFER_FLAGS_DIRECTHFAUTO = 1;
    public static final int EAXBUFFER_FLAGS_ROOMAUTO = 2;
    public static final int EAXBUFFER_FLAGS_ROOMHFAUTO = 4;
    public static final int EAXBUFFER_FLAGS_RESERVED = -8;
    public static final int EAXBUFFER_MINDIRECT = -10000;
    public static final int EAXBUFFER_MAXDIRECT = 1000;
    public static final int EAXBUFFER_DEFAULTDIRECT = 0;
    public static final int EAXBUFFER_MINDIRECTHF = -10000;
    public static final int EAXBUFFER_MAXDIRECTHF = 0;
    public static final int EAXBUFFER_DEFAULTDIRECTHF = 0;
    public static final int EAXBUFFER_MINROOM = -10000;
    public static final int EAXBUFFER_MAXROOM = 1000;
    public static final int EAXBUFFER_DEFAULTROOM = 0;
    public static final int EAXBUFFER_MINROOMHF = -10000;
    public static final int EAXBUFFER_MAXROOMHF = 0;
    public static final int EAXBUFFER_DEFAULTROOMHF = 0;
    public static final float EAXBUFFER_MINROOMROLLOFFFACTOR = 0.0f;
    public static final float EAXBUFFER_MAXROOMROLLOFFFACTOR = 10.0f;
    public static final float EAXBUFFER_DEFAULTROOMROLLOFFFACTOR = 0.0f;
    public static final int EAXBUFFER_MINOBSTRUCTION = -10000;
    public static final int EAXBUFFER_MAXOBSTRUCTION = 0;
    public static final int EAXBUFFER_DEFAULTOBSTRUCTION = 0;
    public static final float EAXBUFFER_MINOBSTRUCTIONLFRATIO = 0.0f;
    public static final float EAXBUFFER_MAXOBSTRUCTIONLFRATIO = 1.0f;
    public static final float EAXBUFFER_DEFAULTOBSTRUCTIONLFRATIO = 0.0f;
    public static final int EAXBUFFER_MINOCCLUSION = -10000;
    public static final int EAXBUFFER_MAXOCCLUSION = 0;
    public static final int EAXBUFFER_DEFAULTOCCLUSION = 0;
    public static final float EAXBUFFER_MINOCCLUSIONLFRATIO = 0.0f;
    public static final float EAXBUFFER_MAXOCCLUSIONLFRATIO = 1.0f;
    public static final float EAXBUFFER_DEFAULTOCCLUSIONLFRATIO = 0.25f;
    public static final float EAXBUFFER_MINOCCLUSIONROOMRATIO = 0.0f;
    public static final float EAXBUFFER_MAXOCCLUSIONROOMRATIO = 10.0f;
    public static final float EAXBUFFER_DEFAULTOCCLUSIONROOMRATIO = 0.5f;
    public static final int EAXBUFFER_MINOUTSIDEVOLUMEHF = -10000;
    public static final int EAXBUFFER_MAXOUTSIDEVOLUMEHF = 0;
    public static final int EAXBUFFER_DEFAULTOUTSIDEVOLUMEHF = 0;
    public static final float EAXBUFFER_MINAIRABSORPTIONFACTOR = 0.0f;
    public static final float EAXBUFFER_MAXAIRABSORPTIONFACTOR = 10.0f;
    public static final float EAXBUFFER_DEFAULTAIRABSORPTIONFACTOR = 1.0f;
    public static final int EAXBUFFER_DEFAULTFLAGS = 7;

    public EAXBufferProperties() {
        this.eaxBufferProperties.order(ByteOrder.nativeOrder());
    }

    public void eaxSet(int n, int n2) {
        EAX.eaxSet(CoreEAX.BUFFER_GUID, n, n2, this.eaxBufferProperties, EAXBUFFERPROPERTIES_SIZE);
    }

    public void eaxGet(int n, int n2) {
        EAX.eaxGet(CoreEAX.BUFFER_GUID, n, n2, this.eaxBufferProperties, EAXBUFFERPROPERTIES_SIZE);
    }

    public int getDirect() {
        return this.eaxBufferProperties.getInt(direct_offset);
    }

    public void setDirect(int n) {
        this.eaxBufferProperties.putInt(direct_offset, n);
    }

    public int getDirectHF() {
        return this.eaxBufferProperties.getInt(directHF_offset);
    }

    public void setDirectHF(int n) {
        this.eaxBufferProperties.putInt(directHF_offset, n);
    }

    public int getRoom() {
        return this.eaxBufferProperties.getInt(room_offset);
    }

    public void setRoom(int n) {
        this.eaxBufferProperties.putInt(room_offset, n);
    }

    public int getRoomHF() {
        return this.eaxBufferProperties.getInt(roomHF_offset);
    }

    public void setRoomHF(int n) {
        this.eaxBufferProperties.putInt(roomHF_offset, n);
    }

    public float getRoomRolloffFactor() {
        return this.eaxBufferProperties.getFloat(roomRolloffFactor_offset);
    }

    public void setRoomRolloffFactor(float f) {
        this.eaxBufferProperties.putFloat(roomRolloffFactor_offset, f);
    }

    public int getObstruction() {
        return this.eaxBufferProperties.getInt(obstruction_offset);
    }

    public void setObstruction(int n) {
        this.eaxBufferProperties.putInt(obstruction_offset, n);
    }

    public float getObstructionLFRatio() {
        return this.eaxBufferProperties.getFloat(obstructionLFRatio_offset);
    }

    public void setObstructionLFRatio(float f) {
        this.eaxBufferProperties.putFloat(obstructionLFRatio_offset, f);
    }

    public int getOcclusion() {
        return this.eaxBufferProperties.getInt(occlusion_offset);
    }

    public void setOcclusion(int n) {
        this.eaxBufferProperties.putInt(occlusion_offset, n);
    }

    public float getOcclusionLFRatio() {
        return this.eaxBufferProperties.getFloat(occlusionLFRatio_offset);
    }

    public void setOcclusionLFRatio(float f) {
        this.eaxBufferProperties.putFloat(occlusionLFRatio_offset, f);
    }

    public float getOcclusionRoomRatio() {
        return this.eaxBufferProperties.getFloat(occlusionRoomRatio_offset);
    }

    public void setOcclusionRoomRatio(float f) {
        this.eaxBufferProperties.putFloat(occlusionRoomRatio_offset, f);
    }

    public int getOutsideVolumeHF() {
        return this.eaxBufferProperties.getInt(outsideVolumeHF_offset);
    }

    public void setOutsideVolumeHF(int n) {
        this.eaxBufferProperties.putInt(outsideVolumeHF_offset, n);
    }

    public float getAirAbsorptionFactor() {
        return this.eaxBufferProperties.getFloat(airAbsorptionFactor_offset);
    }

    public void setAirAbsorptionFactor(float f) {
        this.eaxBufferProperties.putFloat(airAbsorptionFactor_offset, f);
    }

    public int getFlags() {
        return this.eaxBufferProperties.getInt(flags_offset);
    }

    public void setFlags(int n) {
        this.eaxBufferProperties.putInt(flags_offset, n);
    }

    public static int getSize() {
        return EAXBUFFERPROPERTIES_SIZE;
    }

    protected static native int sizeOfEaxBufferProperties();

    protected static native void assignOffsets();

    private static int getSizeOfProperty(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 4;
            }
            case 1: {
                return EAXBUFFERPROPERTIES_SIZE;
            }
        }
        throw new IllegalArgumentException("No such property '" + n + "'");
    }

    static {
        System.loadLibrary(Sys.getLibraryName());
        EAXBUFFERPROPERTIES_SIZE = EAXBufferProperties.sizeOfEaxBufferProperties();
        EAXBufferProperties.assignOffsets();
    }
}

