/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.lwjgl.Display;
import org.lwjgl.Sys;
import org.lwjgl.openal.OpenALException;

public abstract class BaseAL {
    protected static boolean created;

    protected static void init() throws OpenALException {
    }

    private static void initialize() {
        System.loadLibrary(Sys.getLibraryName());
    }

    public static void create() throws OpenALException {
        String string;
        String string2;
        if (created) {
            return;
        }
        String string3 = System.getProperty("java.library.path");
        String string4 = System.getProperty("path.separator");
        switch (Display.getPlatform()) {
            case 0: {
                string2 = "lwjglaudio.dll";
                string = "lwjglaudio";
                break;
            }
            case 1: {
                string2 = "libopenal.so";
                string = "openal";
                break;
            }
            case 2: {
                string2 = "openal.dylib";
                string = "openal";
                break;
            }
            default: {
                throw new OpenALException("Unknown platform");
            }
        }
        String string5 = BaseAL.getPathFromJWS(string);
        if (string5 != null) {
            string3 = string3 + string4 + string5.substring(0, string5.lastIndexOf(File.separator));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
        String[] stringArray = new String[stringTokenizer.countTokens() + 1];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray[i] = stringTokenizer.nextToken() + File.separator + string2;
        }
        stringArray[stringArray.length - 1] = string2;
        BaseAL.nCreate(stringArray);
        BaseAL.init();
        created = true;
    }

    private static String getPathFromJWS(String string) {
        try {
            if (Sys.DEBUG) {
                System.out.println("JWS Classloader looking for: " + string);
            }
            ClassLoader classLoader = BaseAL.class.getClassLoader();
            Class<?> clazz = classLoader.getClass();
            Method method = clazz.getMethod("findLibrary", String.class);
            Object[] objectArray = new Object[]{string};
            return (String)method.invoke((Object)classLoader, objectArray);
        }
        catch (Exception exception) {
            if (Sys.DEBUG) {
                System.out.println("Failure locating OpenAL using classloader:");
                exception.printStackTrace();
            }
            return null;
        }
    }

    protected static native void nCreate(String[] var0) throws OpenALException;

    public static void destroy() {
        if (!created) {
            return;
        }
        created = false;
        BaseAL.nDestroy();
    }

    protected static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    static {
        BaseAL.initialize();
    }
}

