/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;

public class Mouse {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private static boolean created;
    private static byte[] buttons;
    public static int dx;
    public static int dy;
    public static int dwheel;
    public static int buttonCount;
    public static boolean hasWheel;
    private static Cursor currentCursor;
    private static String[] buttonName;
    private static final Map buttonMap;
    private static boolean initialized;
    private static ByteBuffer readBuffer;
    public static int button;
    public static boolean state;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Mouse() {
    }

    public static Cursor getNativeCursor() {
        return currentCursor;
    }

    public static int getNativeCursorCaps() {
        return Mouse.nGetNativeCursorCaps();
    }

    private static native int nGetNativeCursorCaps();

    public static Cursor setNativeCursor(Cursor cursor) throws Exception {
        if (!($assertionsDisabled || created && (Mouse.getNativeCursorCaps() | 1) != 0)) {
            throw new AssertionError();
        }
        Cursor cursor2 = currentCursor;
        currentCursor = cursor;
        if (currentCursor != null) {
            Mouse.nSetNativeCursor(currentCursor.getHandle());
        } else {
            Mouse.nSetNativeCursor(0L);
        }
        return cursor2;
    }

    private static native void nSetNativeCursor(long var0) throws Exception;

    public static int getMinCursorSize() {
        return Mouse.nGetMinCursorSize();
    }

    private static native int nGetMinCursorSize();

    public static int getMaxCursorSize() {
        return Mouse.nGetMaxCursorSize();
    }

    private static native int nGetMaxCursorSize();

    private static void initialize() {
        System.loadLibrary(Sys.getLibraryName());
        Mouse.initIDs();
        buttonName = new String[16];
        for (int i = 0; i < 16; ++i) {
            Mouse.buttonName[i] = "BUTTON" + i;
            buttonMap.put(buttonName[i], new Integer(i));
        }
        initialized = true;
    }

    private static native void initIDs();

    public static void create() throws Exception {
        if (!initialized) {
            Mouse.initialize();
        }
        if (created) {
            return;
        }
        Mouse.nCreate();
        hasWheel = Mouse.nHasWheel();
        created = true;
        currentCursor = null;
        buttonCount = Mouse.nGetButtonCount();
        buttons = new byte[buttonCount];
    }

    private static native boolean nHasWheel();

    private static native int nGetButtonCount();

    private static native void nCreate();

    public static boolean isCreated() {
        return created;
    }

    public static void destroy() {
        if (!$assertionsDisabled && currentCursor != null) {
            throw new AssertionError();
        }
        if (!created) {
            return;
        }
        created = false;
        buttons = null;
        currentCursor = null;
        Mouse.nDestroy();
    }

    private static native void nDestroy();

    public static void poll() {
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)"The mouse has not been created.");
        }
        Mouse.nPoll();
    }

    private static native void nPoll();

    public static boolean isButtonDown(int n) {
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)"The mouse has not been created.");
        }
        if (n >= buttonCount) {
            return false;
        }
        return buttons[n] == 1;
    }

    public static String getButtonName(int n) {
        if (n >= buttonName.length) {
            return null;
        }
        return buttonName[n];
    }

    public static int getButtonIndex(String string) {
        Integer n = (Integer)buttonMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static int enableBuffer() throws Exception {
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)"The mouse has not been created.");
        }
        readBuffer = Mouse.nEnableBuffer();
        if (readBuffer != null) {
            readBuffer.order(ByteOrder.nativeOrder());
        }
        return readBuffer.capacity() / 2;
    }

    private static native ByteBuffer nEnableBuffer() throws Exception;

    public static void read() {
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)"The mouse has not been created.");
        }
        if (!$assertionsDisabled && readBuffer == null) {
            throw new AssertionError((Object)"Mouse buffering has not been enabled.");
        }
        int n = Mouse.nRead();
        readBuffer.clear();
        readBuffer.limit(n << 1);
    }

    private static native int nRead();

    public static boolean next() {
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)"The mouse has not been created.");
        }
        if (!$assertionsDisabled && readBuffer == null) {
            throw new AssertionError((Object)"Mouse buffering has not been enabled.");
        }
        if (readBuffer.hasRemaining()) {
            button = readBuffer.get() & 0xFF;
            state = readBuffer.get() != 0;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !Mouse.class.desiredAssertionStatus();
        buttonCount = -1;
        hasWheel = false;
        buttonMap = new HashMap(16);
    }
}

