/*
 * Decompiled with CFR 0.152.
 */
package jme.utility;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import jme.exception.MonkeyException;

public class LoggingSystem {
    private static LoggingSystem logSystem = null;
    private final Logger logger = Logger.getLogger("jme");
    private Handler handler;

    private LoggingSystem() throws MonkeyException {
        this.logger.setLevel(Level.ALL);
        try {
            this.handler = new FileHandler("debug.txt");
            this.handler.setFormatter(new SimpleFormatter());
            this.logger.addHandler(this.handler);
        }
        catch (IOException iOException) {
            throw new MonkeyException("Could not start Logging System");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
        this.logger.addHandler(handler);
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public void setFormatter(Formatter formatter) {
        this.handler.setFormatter(formatter);
    }

    public static LoggingSystem getLoggingSystem() {
        if (null == logSystem) {
            try {
                logSystem = new LoggingSystem();
                return logSystem;
            }
            catch (MonkeyException monkeyException) {
                monkeyException.printStackTrace();
                return null;
            }
        }
        return logSystem;
    }
}

