/*
 * Decompiled with CFR 0.152.
 */
package jme.system;

import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import jme.exception.MonkeyRuntimeException;
import jme.system.PropertiesDialog;
import jme.system.PropertiesIO;
import jme.utility.LoggingSystem;
import org.lwjgl.Display;
import org.lwjgl.DisplayMode;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCaps;
import org.lwjgl.opengl.Window;

public class DisplaySystem {
    private static String VERSION = "jME version 0.1.0";
    private static DisplaySystem instance = null;
    private int height;
    private int width;
    private int bpp;
    private int freq;
    private boolean fullscreen;
    private String title;

    private DisplaySystem(int n, int n2, int n3, int n4, boolean bl, String string) {
        if (n <= 0 || n2 <= 0) {
            throw new MonkeyRuntimeException("Invalid resolution values: " + n + " " + n2);
        }
        if (n3 != 32 && n3 != 16 && n3 != 24) {
            throw new MonkeyRuntimeException("Invalid pixel depth: " + n3);
        }
        this.width = n;
        this.height = n2;
        this.bpp = n3;
        this.freq = n4;
        this.fullscreen = bl;
        this.title = string;
        this.initDisplay();
    }

    public void setAttributes(int n, int n2, int n3, int n4, boolean bl, String string) {
        if (n < 0 || n2 < 0) {
            throw new MonkeyRuntimeException("Invalid resolution values: " + n + " " + n2);
        }
        if (n3 != 32 && n3 != 16 && n3 != 24) {
            throw new MonkeyRuntimeException("Invalid pixel depth: " + n3);
        }
        this.width = n;
        this.height = n2;
        this.bpp = n3;
        this.freq = n4;
        this.fullscreen = bl;
        this.title = string;
        Window.destroy();
        this.initDisplay();
        Keyboard.destroy();
        Mouse.destroy();
    }

    public static void createDisplaySystem(int n, int n2, int n3, int n4, boolean bl, String string) {
        if (null == instance) {
            instance = new DisplaySystem(n, n2, n3, n4, bl, string);
        }
    }

    public static void createDisplaySystem(String string, String string2, boolean bl) {
        PropertiesIO propertiesIO = new PropertiesIO("properties.cfg");
        if (!propertiesIO.load() || bl) {
            PropertiesDialog propertiesDialog = new PropertiesDialog(propertiesIO, string2);
            while (!propertiesDialog.isDone()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Error waiting for dialog system, using defaults.");
                }
            }
        }
        if (null == instance) {
            instance = new DisplaySystem(propertiesIO.getWidth(), propertiesIO.getHeight(), propertiesIO.getDepth(), propertiesIO.getFreq(), propertiesIO.getFullscreen(), string);
        }
    }

    public static DisplaySystem getDisplaySystem() {
        return instance;
    }

    public DisplayMode getValidDisplayMode(int n, int n2, int n3, int n4) {
        DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
        for (int i = 0; i < displayModeArray.length; ++i) {
            if (displayModeArray[i].width != n || displayModeArray[i].height != n2 || displayModeArray[i].bpp != n3 || displayModeArray[i].freq != n4) continue;
            LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Setting mode to " + displayModeArray[i]);
            return displayModeArray[i];
        }
        return null;
    }

    public static String getVersion() {
        return VERSION;
    }

    public void cullMode(int n, boolean bl) {
        GL.glCullFace((int)n);
        if (bl) {
            GL.glEnable((int)2884);
        } else {
            GL.glDisable((int)2884);
        }
    }

    public boolean takeScreenShot(String string) {
        if (null == string) {
            throw new MonkeyRuntimeException("Screenshot filename cannot be null");
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Taking screenshot: " + string + ".png");
        IntBuffer intBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL.glReadPixels((int)0, (int)0, (int)this.width, (int)this.height, (int)32993, (int)5121, (IntBuffer)intBuffer);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                bufferedImage.setRGB(i, j, intBuffer.get((this.height - j - 1) * this.width + i));
            }
        }
        try {
            File file = new File(string + ".png");
            return ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Could not create file: " + string + ".png");
            return false;
        }
    }

    private void initDisplay() {
        try {
            DisplayMode displayMode = this.getValidDisplayMode(this.width, this.height, this.bpp, this.freq);
            if (null == displayMode) {
                throw new MonkeyRuntimeException("Bad display mode");
            }
            if (this.fullscreen) {
                Display.setDisplayMode((DisplayMode)displayMode);
                Window.create((String)this.title, (int)this.bpp, (int)0, (int)8, (int)0);
            } else {
                int n = (Toolkit.getDefaultToolkit().getScreenSize().width - this.width) / 2;
                int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - this.height) / 2;
                Window.create((String)this.title, (int)n, (int)n2, (int)this.width, (int)this.height, (int)this.bpp, (int)0, (int)8, (int)0);
            }
            GLCaps.determineAvailableExtensions();
            LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created display.");
        }
        catch (Exception exception) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.SEVERE, "Failed to create display due to " + exception);
            System.exit(1);
        }
    }
}

