/*
 * Decompiled with CFR 0.152.
 */
package jme.physics.mobile;

import java.util.logging.Level;
import jme.math.Vector;
import jme.physics.PhysicsModule;
import jme.utility.LoggingSystem;

public class LandMobility
implements PhysicsModule {
    private float currentTurningVel;
    private float maxVelocity;
    private float minVelocity;
    private float baseAcceleration;
    private float coastDeceleration;
    private float currentAcceleration;
    private float currentVelocity;
    private float prevVelocity;
    private float turningVelocity;
    private float currentAngle;
    private float distance;
    private boolean moving;

    public LandMobility() {
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "LandMobility physics module created.");
    }

    public void update(float f) {
        if (this.moving) {
            this.currentVelocity = this.prevVelocity + this.currentAcceleration * f;
            if (this.currentVelocity > this.maxVelocity) {
                this.currentVelocity = this.maxVelocity;
            } else if (this.currentVelocity < this.minVelocity) {
                this.currentVelocity = this.minVelocity;
            }
        } else if (this.currentVelocity > 0.0f) {
            this.currentVelocity -= this.coastDeceleration * f;
            if (this.currentVelocity < 0.0f) {
                this.currentVelocity = 0.0f;
            }
        } else if (this.currentVelocity < 0.0f) {
            this.currentVelocity += this.coastDeceleration * f;
            if (this.currentVelocity > 0.0f) {
                this.currentVelocity = 0.0f;
            }
        }
        this.prevVelocity = this.currentVelocity;
        if (f < Float.MAX_VALUE) {
            this.distance += this.currentVelocity * f;
            this.currentAngle += this.currentTurningVel * f;
        }
        this.moving = false;
    }

    public void updatePosition(Vector vector) {
        float f = (float)Math.sin(Math.toRadians(this.currentAngle));
        float f2 = (float)Math.cos(Math.toRadians(this.currentAngle));
        vector.x += f * this.distance;
        vector.z += f2 * this.distance;
        this.distance = 0.0f;
    }

    public void turn(float f) {
        this.currentTurningVel = this.turningVelocity * f;
    }

    public void move(float f) {
        this.currentAcceleration = this.baseAcceleration * f;
        this.moving = true;
    }

    public void strafe(float f) {
    }

    public void setCoastDeceleration(float f) {
        this.coastDeceleration = f;
    }

    public void setMaxVelocity(float f) {
        this.maxVelocity = f;
    }

    public void setMinVelocity(float f) {
        this.minVelocity = f;
    }

    public void setTurningVelocity(float f) {
        this.turningVelocity = f;
    }

    public void setBaseAcceleration(float f) {
        this.baseAcceleration = f;
    }

    public void setCurrentAngle(float f) {
        this.currentAngle = f;
    }

    public float getCurrentAngle() {
        return this.currentAngle;
    }

    public float getCurrentVelocity() {
        return this.currentVelocity;
    }

    public float getCurrentTurningVel() {
        return this.currentTurningVel;
    }
}

