/*
 * Decompiled with CFR 0.152.
 */
package jme.math;

import jme.exception.MonkeyRuntimeException;
import jme.math.Quaternion;
import jme.math.Vector;

public class Matrix {
    public float[][] matrix;

    public Matrix() {
        this.loadIdentity();
    }

    public Matrix(Matrix matrix) {
        if (null == matrix) {
            this.loadIdentity();
        } else {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.matrix[i][j] = matrix.getMatrix()[i][j];
                }
            }
        }
    }

    public void loadIdentity() {
        this.matrix = new float[4][4];
        this.matrix[3][3] = 1.0f;
        this.matrix[2][2] = 1.0f;
        this.matrix[1][1] = 1.0f;
        this.matrix[0][0] = 1.0f;
    }

    public void set(float[][] fArray) {
        if (fArray.length != 4 || fArray[0].length != 4) {
            throw new MonkeyRuntimeException("Array must be of size 16.");
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.matrix[i][j] = fArray[i][j];
            }
        }
    }

    public void set(float[] fArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.matrix[i][j] = fArray[j * 4 + i];
            }
        }
    }

    public void set(Quaternion quaternion) {
        this.matrix[0][0] = (float)(1.0 - 2.0 * (double)quaternion.y * (double)quaternion.y - 2.0 * (double)quaternion.z * (double)quaternion.z);
        this.matrix[1][0] = (float)(2.0 * (double)quaternion.x * (double)quaternion.y + 2.0 * (double)quaternion.w * (double)quaternion.z);
        this.matrix[2][0] = (float)(2.0 * (double)quaternion.x * (double)quaternion.z - 2.0 * (double)quaternion.w * (double)quaternion.y);
        this.matrix[0][1] = (float)(2.0 * (double)quaternion.x * (double)quaternion.y - 2.0 * (double)quaternion.w * (double)quaternion.z);
        this.matrix[1][1] = (float)(1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.z * (double)quaternion.z);
        this.matrix[2][1] = (float)(2.0 * (double)quaternion.y * (double)quaternion.z + 2.0 * (double)quaternion.w * (double)quaternion.x);
        this.matrix[0][2] = (float)(2.0 * (double)quaternion.x * (double)quaternion.z + 2.0 * (double)quaternion.w * (double)quaternion.y);
        this.matrix[1][2] = (float)(2.0 * (double)quaternion.y * (double)quaternion.z - 2.0 * (double)quaternion.w * (double)quaternion.x);
        this.matrix[2][2] = (float)(1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.y * (double)quaternion.y);
    }

    public void copy(Matrix matrix) {
        if (null == matrix) {
            this.loadIdentity();
        } else {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.matrix[i][j] = matrix.matrix[i][j];
                }
            }
        }
    }

    public void add(Matrix matrix) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float[] fArray = this.matrix[i];
                int n = j;
                fArray[n] = fArray[n] + matrix.getMatrix()[i][j];
            }
        }
    }

    public void multiply(float f) {
        for (int i = 0; i < 4; ++i) {
            int n = 0;
            while (n < 4) {
                float[] fArray = this.matrix[i];
                int n2 = n++;
                fArray[n2] = fArray[n2] * f;
            }
        }
    }

    public Matrix multiply(Matrix matrix) {
        Matrix matrix2 = new Matrix();
        matrix2.matrix[0][0] = this.matrix[0][0] * matrix.matrix[0][0] + this.matrix[0][1] * matrix.matrix[1][0] + this.matrix[0][2] * matrix.matrix[2][0];
        matrix2.matrix[0][1] = this.matrix[0][0] * matrix.matrix[0][1] + this.matrix[0][1] * matrix.matrix[1][1] + this.matrix[0][2] * matrix.matrix[2][1];
        matrix2.matrix[0][2] = this.matrix[0][0] * matrix.matrix[0][2] + this.matrix[0][1] * matrix.matrix[1][2] + this.matrix[0][2] * matrix.matrix[2][2];
        matrix2.matrix[0][3] = this.matrix[0][0] * matrix.matrix[0][3] + this.matrix[0][1] * matrix.matrix[1][3] + this.matrix[0][2] * matrix.matrix[2][3] + this.matrix[0][3];
        matrix2.matrix[1][0] = this.matrix[1][0] * matrix.matrix[0][0] + this.matrix[1][1] * matrix.matrix[1][0] + this.matrix[1][2] * matrix.matrix[2][0];
        matrix2.matrix[1][1] = this.matrix[1][0] * matrix.matrix[0][1] + this.matrix[1][1] * matrix.matrix[1][1] + this.matrix[1][2] * matrix.matrix[2][1];
        matrix2.matrix[1][2] = this.matrix[1][0] * matrix.matrix[0][2] + this.matrix[1][1] * matrix.matrix[1][2] + this.matrix[1][2] * matrix.matrix[2][2];
        matrix2.matrix[1][3] = this.matrix[1][0] * matrix.matrix[0][3] + this.matrix[1][1] * matrix.matrix[1][3] + this.matrix[1][2] * matrix.matrix[2][3] + this.matrix[1][3];
        matrix2.matrix[2][0] = this.matrix[2][0] * matrix.matrix[0][0] + this.matrix[2][1] * matrix.matrix[1][0] + this.matrix[2][2] * matrix.matrix[2][0];
        matrix2.matrix[2][1] = this.matrix[2][0] * matrix.matrix[0][1] + this.matrix[2][1] * matrix.matrix[1][1] + this.matrix[2][2] * matrix.matrix[2][1];
        matrix2.matrix[2][2] = this.matrix[2][0] * matrix.matrix[0][2] + this.matrix[2][1] * matrix.matrix[1][2] + this.matrix[2][2] * matrix.matrix[2][2];
        matrix2.matrix[2][3] = this.matrix[2][0] * matrix.matrix[0][3] + this.matrix[2][1] * matrix.matrix[1][3] + this.matrix[2][2] * matrix.matrix[2][3] + this.matrix[2][3];
        matrix2.matrix[3][0] = this.matrix[0][0] * matrix.getMatrix()[3][0] + this.matrix[1][0] * matrix.getMatrix()[3][1] + this.matrix[2][0] * matrix.getMatrix()[3][2] + this.matrix[3][0];
        matrix2.matrix[3][1] = this.matrix[0][1] * matrix.getMatrix()[3][0] + this.matrix[1][1] * matrix.getMatrix()[3][1] + this.matrix[2][1] * matrix.getMatrix()[3][2] + this.matrix[3][1];
        matrix2.matrix[3][2] = this.matrix[0][2] * matrix.getMatrix()[3][0] + this.matrix[1][2] * matrix.getMatrix()[3][1] + this.matrix[2][2] * matrix.getMatrix()[3][2] + this.matrix[3][2];
        matrix2.matrix[3][3] = 1.0f;
        return matrix2;
    }

    public void setTranslation(float[] fArray) {
        if (fArray.length != 3) {
            throw new MonkeyRuntimeException("Translation size must be 3.");
        }
        this.matrix[3][0] = fArray[0];
        this.matrix[3][1] = fArray[1];
        this.matrix[3][2] = fArray[2];
    }

    public void setInverseTranslation(float[] fArray) {
        if (fArray.length != 3) {
            throw new MonkeyRuntimeException("Translation size must be 3.");
        }
        this.matrix[3][0] = -fArray[0];
        this.matrix[3][1] = -fArray[1];
        this.matrix[3][2] = -fArray[2];
    }

    public void angleRotationRadians(Vector vector) {
        float f = (float)Math.sin(vector.z);
        float f2 = (float)Math.cos(vector.z);
        float f3 = (float)Math.sin(vector.y);
        float f4 = (float)Math.cos(vector.y);
        float f5 = (float)Math.sin(vector.x);
        float f6 = (float)Math.cos(vector.x);
        this.matrix[0][0] = f4 * f2;
        this.matrix[1][0] = f4 * f;
        this.matrix[2][0] = -f3;
        this.matrix[0][1] = f5 * f3 * f2 + f6 * -f;
        this.matrix[1][1] = f5 * f3 * f + f6 * f2;
        this.matrix[2][1] = f5 * f4;
        this.matrix[0][2] = f6 * f3 * f2 + -f5 * -f;
        this.matrix[1][2] = f6 * f3 * f + -f5 * f2;
        this.matrix[2][2] = f6 * f4;
        this.matrix[0][3] = 0.0f;
        this.matrix[1][3] = 0.0f;
        this.matrix[2][3] = 0.0f;
    }

    public void angleRotationDegrees(Vector vector) {
        float f = (float)((double)vector.z * (Math.PI / 180));
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        f = (float)((double)vector.y * (Math.PI / 180));
        float f4 = (float)Math.sin(f);
        float f5 = (float)Math.cos(f);
        f = (float)((double)vector.x * (Math.PI / 180));
        float f6 = (float)Math.sin(f);
        float f7 = (float)Math.cos(f);
        this.matrix[0][0] = f5 * f3;
        this.matrix[1][0] = f5 * f2;
        this.matrix[2][0] = -f4;
        this.matrix[0][1] = f6 * f4 * f3 + f7 * -f2;
        this.matrix[1][1] = f6 * f4 * f2 + f7 * f3;
        this.matrix[2][1] = f6 * f5;
        this.matrix[0][2] = f7 * f4 * f3 + -f6 * -f2;
        this.matrix[1][2] = f7 * f4 * f2 + -f6 * f3;
        this.matrix[2][2] = f7 * f5;
        this.matrix[0][3] = 0.0f;
        this.matrix[1][3] = 0.0f;
        this.matrix[2][3] = 0.0f;
    }

    public void setRotationQuaternion(Quaternion quaternion) {
        if (null == quaternion) {
            throw new MonkeyRuntimeException("Quat may not be null.");
        }
        this.matrix[0][0] = (float)(1.0 - 2.0 * (double)quaternion.y * (double)quaternion.y - 2.0 * (double)quaternion.z * (double)quaternion.z);
        this.matrix[0][1] = (float)(2.0 * (double)quaternion.x * (double)quaternion.y + 2.0 * (double)quaternion.w * (double)quaternion.z);
        this.matrix[0][2] = (float)(2.0 * (double)quaternion.x * (double)quaternion.z - 2.0 * (double)quaternion.w * (double)quaternion.y);
        this.matrix[1][0] = (float)(2.0 * (double)quaternion.x * (double)quaternion.y - 2.0 * (double)quaternion.w * (double)quaternion.z);
        this.matrix[1][1] = (float)(1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.z * (double)quaternion.z);
        this.matrix[1][2] = (float)(2.0 * (double)quaternion.y * (double)quaternion.z + 2.0 * (double)quaternion.w * (double)quaternion.x);
        this.matrix[2][0] = (float)(2.0 * (double)quaternion.x * (double)quaternion.z + 2.0 * (double)quaternion.w * (double)quaternion.y);
        this.matrix[2][1] = (float)(2.0 * (double)quaternion.y * (double)quaternion.z - 2.0 * (double)quaternion.w * (double)quaternion.x);
        this.matrix[2][2] = (float)(1.0 - 2.0 * (double)quaternion.x * (double)quaternion.x - 2.0 * (double)quaternion.y * (double)quaternion.y);
    }

    public void setInverseRotationRadians(float[] fArray) {
        if (fArray.length != 3) {
            throw new MonkeyRuntimeException("Angles must be of size 3.");
        }
        double d = Math.cos(fArray[0]);
        double d2 = Math.sin(fArray[0]);
        double d3 = Math.cos(fArray[1]);
        double d4 = Math.sin(fArray[1]);
        double d5 = Math.cos(fArray[2]);
        double d6 = Math.sin(fArray[2]);
        this.matrix[0][0] = (float)(d3 * d5);
        this.matrix[1][0] = (float)(d3 * d6);
        this.matrix[2][0] = (float)(-d4);
        double d7 = d2 * d4;
        double d8 = d * d4;
        this.matrix[0][1] = (float)(d7 * d5 - d * d6);
        this.matrix[1][1] = (float)(d7 * d6 + d * d5);
        this.matrix[2][1] = (float)(d2 * d3);
        this.matrix[0][2] = (float)(d8 * d5 + d2 * d6);
        this.matrix[1][2] = (float)(d8 * d6 - d2 * d5);
        this.matrix[2][2] = (float)(d * d3);
    }

    public void setInverseRotationDegrees(float[] fArray) {
        if (fArray.length != 3) {
            throw new MonkeyRuntimeException("Angles must be of size 3.");
        }
        float[] fArray2 = new float[]{(float)((double)fArray[0] * 180.0 / Math.PI), (float)((double)fArray[1] * 180.0 / Math.PI), (float)((double)fArray[2] * 180.0 / Math.PI)};
        this.setInverseRotationRadians(fArray2);
    }

    public float[][] getMatrix() {
        return this.matrix;
    }

    public void inverseTranslateVect(float[] fArray) {
        if (fArray.length != 3) {
            throw new MonkeyRuntimeException("Vector must be of size 3.");
        }
        fArray[0] = fArray[0] - this.matrix[3][0];
        fArray[1] = fArray[1] - this.matrix[3][1];
        fArray[2] = fArray[2] - this.matrix[3][2];
    }

    public void inverseRotateVect(float[] fArray) {
        if (fArray.length != 3) {
            throw new MonkeyRuntimeException("Vector must be of size 3.");
        }
        fArray[0] = fArray[0] * this.matrix[0][0] + fArray[1] * this.matrix[0][1] + fArray[2] * this.matrix[0][2];
        fArray[1] = fArray[0] * this.matrix[1][0] + fArray[1] * this.matrix[1][1] + fArray[2] * this.matrix[1][2];
        fArray[2] = fArray[0] * this.matrix[2][0] + fArray[1] * this.matrix[2][1] + fArray[2] * this.matrix[2][2];
    }

    public void tensorProduct(Vector vector, Vector vector2) {
        this.matrix[0][0] = vector.x * vector2.x;
        this.matrix[0][1] = vector.x * vector2.y;
        this.matrix[0][2] = vector.x * vector2.z;
        this.matrix[1][0] = vector.y * vector2.x;
        this.matrix[1][1] = vector.y * vector2.y;
        this.matrix[1][2] = vector.y * vector2.z;
        this.matrix[2][0] = vector.z * vector2.x;
        this.matrix[2][1] = vector.z * vector2.y;
        this.matrix[2][2] = vector.z * vector2.z;
    }
}

