/*
 * Decompiled with CFR 0.152.
 */
package jme.math;

import jme.math.Line;
import jme.math.Rectangle;
import jme.math.Vector;

public class Distance {
    private static final float TOLERANCE = 1.0E-5f;

    public static float distancePointPoint(Vector vector, Vector vector2) {
        return (float)Math.sqrt(Distance.distancePointPointSquared(vector, vector2));
    }

    public static float distancePointPointSquared(Vector vector, Vector vector2) {
        return (vector.x - vector2.x) * (vector.x - vector2.x) + (vector.y - vector2.y) * (vector.y - vector2.y) + (vector.z - vector2.z) * (vector.z - vector2.z);
    }

    public static float distancePointLineSquared(Vector vector, Line line) {
        Vector vector2 = vector.subtract(line.getOrigin());
        float f = line.getDirection().lengthSquared();
        float f2 = vector2.dot(line.getDirection()) / f;
        vector2 = vector2.subtract(line.getDirection().mult(f2));
        return vector2.lengthSquared();
    }

    public static float distancePointRaySquared(Vector vector, Line line) {
        Vector vector2 = vector.subtract(line.getOrigin());
        float f = vector2.dot(line.getDirection());
        if ((double)f <= 0.0) {
            f = 0.0f;
        } else {
            vector2 = vector2.subtract(line.getDirection().mult(f /= line.getDirection().lengthSquared()));
        }
        return vector2.lengthSquared();
    }

    public static float distancePointSegmentSquared(Vector vector, Line line) {
        Vector vector2 = vector.subtract(line.getOrigin());
        float f = vector2.dot(line.getDirection());
        if (f <= 0.0f) {
            f = 0.0f;
        } else {
            float f2 = line.getDirection().lengthSquared();
            if (f >= f2) {
                f = 1.0f;
                vector2 = vector2.subtract(line.getDirection());
            } else {
                vector2 = vector2.subtract(line.getDirection().mult(f /= f2));
            }
        }
        return vector2.lengthSquared();
    }

    public static float distancePointRectangle(Vector vector, Rectangle rectangle) {
        Vector vector2 = rectangle.getOrigin().subtract(vector);
        float f = rectangle.getFirstEdge().lengthSquared();
        float f2 = rectangle.getSecondEdge().lengthSquared();
        float f3 = vector2.dot(rectangle.getFirstEdge());
        float f4 = vector2.dot(rectangle.getSecondEdge());
        float f5 = -f3;
        float f6 = -f4;
        float f7 = vector2.lengthSquared();
        if ((double)f5 < 0.0) {
            f5 = 0.0f;
        } else if (f5 <= f) {
            f7 += f3 * (f5 /= f);
        } else {
            f5 = 1.0f;
            f7 = (float)((double)f7 + ((double)f + 2.0 * (double)f3));
        }
        if ((double)f6 < 0.0) {
            f6 = 0.0f;
        } else if (f6 <= f2) {
            f7 += f4 * (f6 /= f2);
        } else {
            f6 = 1.0f;
            f7 = (float)((double)f7 + ((double)f2 + 2.0 * (double)f4));
        }
        return Math.abs(f7);
    }

    public static float distanceLineLineSquared(Line line, Line line2) {
        float f;
        Vector vector = line.getOrigin().subtract(line2.getOrigin());
        float f2 = line.getDirection().lengthSquared();
        float f3 = -line.getDirection().dot(line2.getDirection());
        float f4 = line2.getDirection().lengthSquared();
        float f5 = vector.dot(line.getDirection());
        float f6 = vector.lengthSquared();
        float f7 = Math.abs(f2 * f4 - f3 * f3);
        if (f7 >= 1.0E-5f) {
            float f8 = -vector.dot(line2.getDirection());
            float f9 = 1.0f / f7;
            float f10 = (f3 * f8 - f4 * f5) * f9;
            float f11 = (f3 * f5 - f2 * f8) * f9;
            f = f10 * (f2 * f10 + f3 * f11 + 2.0f * f5) + f11 * (f3 * f10 + f4 * f11 + 2.0f * f8) + f6;
        } else {
            float f12 = -f5 / f2;
            float f13 = 0.0f;
            f = f5 * f12 + f6;
        }
        return Math.abs(f);
    }

    public static float distanceLineRaySquared(Line line, Line line2) {
        float f;
        Vector vector = line.getOrigin().subtract(line2.getOrigin());
        float f2 = line.getDirection().lengthSquared();
        float f3 = -line.getDirection().dot(line2.getDirection());
        float f4 = line2.getDirection().lengthSquared();
        float f5 = vector.dot(line.getDirection());
        float f6 = vector.lengthSquared();
        float f7 = Math.abs(f2 * f4 - f3 * f3);
        if (f7 >= 1.0E-5f) {
            float f8 = -vector.dot(line2.getDirection());
            float f9 = f3 * f5 - f2 * f8;
            if ((double)f9 >= 0.0) {
                float f10 = 1.0f / f7;
                float f11 = (f3 * f8 - f4 * f5) * f10;
                f = f11 * (f2 * f11 + f3 * (f9 *= f10) + 2.0f * f5) + f9 * (f3 * f11 + f4 * f9 + 2.0f * f8) + f6;
            } else {
                float f12 = -f5 / f2;
                f9 = 0.0f;
                f = f5 * f12 + f6;
            }
        } else {
            float f13 = -f5 / f2;
            float f14 = 0.0f;
            f = f5 * f13 + f6;
        }
        return Math.abs(f);
    }

    public static float distanceLineSegmentSquared(Line line, Line line2) {
        float f;
        Vector vector = line.getOrigin().subtract(line2.getOrigin());
        float f2 = line.getDirection().lengthSquared();
        float f3 = -line.getDirection().dot(line2.getDirection());
        float f4 = line2.getDirection().lengthSquared();
        float f5 = vector.dot(line.getDirection());
        float f6 = vector.lengthSquared();
        float f7 = Math.abs(f2 * f4 - f3 * f3);
        if (f7 >= 1.0E-5f) {
            float f8 = -vector.dot(line2.getDirection());
            float f9 = f3 * f5 - f2 * f8;
            if ((double)f9 >= 0.0) {
                if (f9 <= f7) {
                    float f10 = 1.0f / f7;
                    float f11 = (f3 * f8 - f4 * f5) * f10;
                    f = f11 * (f2 * f11 + f3 * (f9 *= f10) + 2.0f * f5) + f9 * (f3 * f11 + f4 * f9 + 2.0f * f8) + f6;
                } else {
                    float f12 = f3 + f5;
                    float f13 = -f12 / f2;
                    f9 = 1.0f;
                    f = f12 * f13 + f4 + 2.0f * f8 + f6;
                }
            } else {
                float f14 = -f5 / f2;
                f9 = 0.0f;
                f = f5 * f14 + f6;
            }
        } else {
            float f15 = -f5 / f2;
            float f16 = 0.0f;
            f = f5 * f15 + f6;
        }
        return Math.abs(f);
    }

    public static float distanceRayRaySquared(Line line, Line line2) {
        float f;
        Vector vector = line.getOrigin().subtract(line2.getOrigin());
        float f2 = line.getDirection().lengthSquared();
        float f3 = -line.getDirection().dot(line2.getDirection());
        float f4 = line2.getDirection().lengthSquared();
        float f5 = vector.dot(line.getDirection());
        float f6 = vector.lengthSquared();
        float f7 = Math.abs(f2 * f4 - f3 * f3);
        if (f7 >= 1.0E-5f) {
            float f8 = -vector.dot(line2.getDirection());
            float f9 = f3 * f8 - f4 * f5;
            float f10 = f3 * f5 - f2 * f8;
            if ((double)f9 >= 0.0) {
                if ((double)f10 >= 0.0) {
                    float f11 = 1.0f / f7;
                    f = (f9 *= f11) * (f2 * f9 + f3 * (f10 *= f11) + 2.0f * f5) + f10 * (f3 * f9 + f4 * f10 + 2.0f * f8) + f6;
                } else {
                    f10 = 0.0f;
                    if ((double)f5 >= 0.0) {
                        f9 = 0.0f;
                        f = f6;
                    } else {
                        f9 = -f5 / f2;
                        f = f5 * f9 + f6;
                    }
                }
            } else if ((double)f10 >= 0.0) {
                f9 = 0.0f;
                if ((double)f8 >= 0.0) {
                    f10 = 0.0f;
                    f = f6;
                } else {
                    f10 = -f8 / f4;
                    f = f8 * f10 + f6;
                }
            } else if ((double)f5 < 0.0) {
                f9 = -f5 / f2;
                f10 = 0.0f;
                f = f5 * f9 + f6;
            } else {
                f9 = 0.0f;
                if ((double)f8 >= 0.0) {
                    f10 = 0.0f;
                    f = f6;
                } else {
                    f10 = -f8 / f4;
                    f = f8 * f10 + f6;
                }
            }
        } else if ((double)f3 > 0.0) {
            float f12 = 0.0f;
            if ((double)f5 >= 0.0) {
                float f13 = 0.0f;
                f = f6;
            } else {
                float f14 = -f5 / f2;
                f = f5 * f14 + f6;
            }
        } else if ((double)f5 >= 0.0) {
            float f15 = -vector.dot(line2.getDirection());
            float f16 = 0.0f;
            float f17 = -f15 / f4;
            f = f15 * f17 + f6;
        } else {
            float f18 = -f5 / f2;
            float f19 = 0.0f;
            f = f5 * f18 + f6;
        }
        return Math.abs(f);
    }

    public static float distanceRaySegmentSquared(Line line, Line line2) {
        float f;
        Vector vector = line.getOrigin().subtract(line2.getOrigin());
        float f2 = line.getDirection().lengthSquared();
        float f3 = -line.getDirection().dot(line2.getDirection());
        float f4 = line2.getDirection().lengthSquared();
        float f5 = vector.dot(line.getDirection());
        float f6 = vector.lengthSquared();
        float f7 = Math.abs(f2 * f4 - f3 * f3);
        if (f7 >= 1.0E-5f) {
            float f8 = -vector.dot(line2.getDirection());
            float f9 = f3 * f8 - f4 * f5;
            float f10 = f3 * f5 - f2 * f8;
            if ((double)f9 >= 0.0) {
                if ((double)f10 >= 0.0) {
                    if (f10 <= f7) {
                        float f11 = 1.0f / f7;
                        f = (f9 *= f11) * (f2 * f9 + f3 * (f10 *= f11) + 2.0f * f5) + f10 * (f3 * f9 + f4 * f10 + 2.0f * f8) + f6;
                    } else {
                        f10 = 1.0f;
                        if (f5 >= -f3) {
                            f9 = 0.0f;
                            f = f4 + 2.0f * f8 + f6;
                        } else {
                            float f12 = f3 + f5;
                            f9 = -f12 / f2;
                            f = f12 * f9 + f4 + 2.0f * f8 + f6;
                        }
                    }
                } else {
                    f10 = 0.0f;
                    if ((double)f5 >= 0.0) {
                        f9 = 0.0f;
                        f = f6;
                    } else {
                        f9 = -f5 / f2;
                        f = f5 * f9 + f6;
                    }
                }
            } else if ((double)f10 <= 0.0) {
                if ((double)f5 < 0.0) {
                    f9 = -f5 / f2;
                    f10 = 0.0f;
                    f = f5 * f9 + f6;
                } else {
                    f9 = 0.0f;
                    if ((double)f8 >= 0.0) {
                        f10 = 0.0f;
                        f = f6;
                    } else if (-f8 >= f4) {
                        f10 = 1.0f;
                        f = f4 + 2.0f * f8 + f6;
                    } else {
                        f10 = -f8 / f4;
                        f = f8 * f10 + f6;
                    }
                }
            } else if (f10 <= f7) {
                f9 = 0.0f;
                if ((double)f8 >= 0.0) {
                    f10 = 0.0f;
                    f = f6;
                } else if (-f8 >= f4) {
                    f10 = 1.0f;
                    f = f4 + 2.0f * f8 + f6;
                } else {
                    f10 = -f8 / f4;
                    f = f8 * f10 + f6;
                }
            } else {
                float f13 = f3 + f5;
                if ((double)f13 < 0.0) {
                    f9 = -f13 / f2;
                    f10 = 1.0f;
                    f = f13 * f9 + f4 + 2.0f * f8 + f6;
                } else {
                    f9 = 0.0f;
                    if ((double)f8 >= 0.0) {
                        f10 = 0.0f;
                        f = f6;
                    } else if (-f8 >= f4) {
                        f10 = 1.0f;
                        f = f4 + 2.0f * f8 + f6;
                    } else {
                        f10 = -f8 / f4;
                        f = f8 * f10 + f6;
                    }
                }
            }
        } else if ((double)f3 > 0.0) {
            float f14 = 0.0f;
            if ((double)f5 >= 0.0) {
                float f15 = 0.0f;
                f = f6;
            } else {
                float f16 = -f5 / f2;
                f = f5 * f16 + f6;
            }
        } else {
            float f17 = -vector.dot(line2.getDirection());
            float f18 = 1.0f;
            float f19 = f3 + f5;
            if ((double)f19 >= 0.0) {
                float f20 = 0.0f;
                f = f4 + 2.0f * f17 + f6;
            } else {
                float f21 = -f19 / f2;
                f = f19 * f21 + f4 + 2.0f * f17 + f6;
            }
        }
        return Math.abs(f);
    }

    public static float distanceSegmentSegmentSquared(Line line, Line line2) {
        float f;
        Vector vector = line.getOrigin().subtract(line2.getOrigin());
        float f2 = line.getDirection().lengthSquared();
        float f3 = -line.getDirection().dot(line2.getDirection());
        float f4 = line2.getDirection().lengthSquared();
        float f5 = vector.dot(line.getDirection());
        float f6 = vector.lengthSquared();
        float f7 = Math.abs(f2 * f4 - f3 * f3);
        if (f7 >= 1.0E-5f) {
            float f8 = -vector.dot(line2.getDirection());
            float f9 = f3 * f8 - f4 * f5;
            float f10 = f3 * f5 - f2 * f8;
            if ((double)f9 >= 0.0) {
                if (f9 <= f7) {
                    if ((double)f10 >= 0.0) {
                        if (f10 <= f7) {
                            float f11 = 1.0f / f7;
                            f = (f9 *= f11) * (f2 * f9 + f3 * (f10 *= f11) + 2.0f * f5) + f10 * (f3 * f9 + f4 * f10 + 2.0f * f8) + f6;
                        } else {
                            f10 = 1.0f;
                            float f12 = f3 + f5;
                            if (f12 >= 0.0f) {
                                f9 = 0.0f;
                                f = f4 + 2.0f * f8 + f6;
                            } else if (-f12 >= f2) {
                                f9 = 1.0f;
                                f = f2 + f4 + f6 + 2.0f * (f8 + f12);
                            } else {
                                f9 = -f12 / f2;
                                f = f12 * f9 + f4 + 2.0f * f8 + f6;
                            }
                        }
                    } else {
                        f10 = 0.0f;
                        if (f5 >= 0.0f) {
                            f9 = 0.0f;
                            f = f6;
                        } else if (-f5 >= f2) {
                            f9 = 1.0f;
                            f = f2 + 2.0f * f5 + f6;
                        } else {
                            f9 = -f5 / f2;
                            f = f5 * f9 + f6;
                        }
                    }
                } else if (f10 >= 0.0f) {
                    if (f10 <= f7) {
                        f9 = 1.0f;
                        float f13 = f3 + f8;
                        if (f13 >= 0.0f) {
                            f10 = 0.0f;
                            f = f2 + 2.0f * f5 + f6;
                        } else if (-f13 >= f4) {
                            f10 = 1.0f;
                            f = f2 + f4 + f6 + 2.0f * (f5 + f13);
                        } else {
                            f10 = -f13 / f4;
                            f = f13 * f10 + f2 + 2.0f * f5 + f6;
                        }
                    } else {
                        float f14 = f3 + f5;
                        if (-f14 <= f2) {
                            f10 = 1.0f;
                            if (f14 >= 0.0f) {
                                f9 = 0.0f;
                                f = f4 + 2.0f * f8 + f6;
                            } else {
                                f9 = -f14 / f2;
                                f = f14 * f9 + f4 + 2.0f * f8 + f6;
                            }
                        } else {
                            f9 = 1.0f;
                            f14 = f3 + f8;
                            if (f14 >= 0.0f) {
                                f10 = 0.0f;
                                f = f2 + 2.0f * f5 + f6;
                            } else if (-f14 >= f4) {
                                f10 = 1.0f;
                                f = f2 + f4 + f6 + 2.0f * (f5 + f14);
                            } else {
                                f10 = -f14 / f4;
                                f = f14 * f10 + f2 + 2.0f * f5 + f6;
                            }
                        }
                    }
                } else if (-f5 < f2) {
                    f10 = 0.0f;
                    if (f5 >= 0.0f) {
                        f9 = 0.0f;
                        f = f6;
                    } else {
                        f9 = -f5 / f2;
                        f = f5 * f9 + f6;
                    }
                } else {
                    f9 = 1.0f;
                    float f15 = f3 + f8;
                    if (f15 >= 0.0f) {
                        f10 = 0.0f;
                        f = f2 + 2.0f * f5 + f6;
                    } else if (-f15 >= f4) {
                        f10 = 1.0f;
                        f = f2 + f4 + f6 + 2.0f * (f5 + f15);
                    } else {
                        f10 = -f15 / f4;
                        f = f15 * f10 + f2 + 2.0f * f5 + f6;
                    }
                }
            } else if (f10 >= 0.0f) {
                if (f10 <= f7) {
                    f9 = 0.0f;
                    if (f8 >= 0.0f) {
                        f10 = 0.0f;
                        f = f6;
                    } else if (-f8 >= f4) {
                        f10 = 1.0f;
                        f = f4 + 2.0f * f8 + f6;
                    } else {
                        f10 = -f8 / f4;
                        f = f8 * f10 + f6;
                    }
                } else {
                    float f16 = f3 + f5;
                    if (f16 < 0.0f) {
                        f10 = 1.0f;
                        if (-f16 >= f2) {
                            f9 = 1.0f;
                            f = f2 + f4 + f6 + 2.0f * (f8 + f16);
                        } else {
                            f9 = -f16 / f2;
                            f = f16 * f9 + f4 + 2.0f * f8 + f6;
                        }
                    } else {
                        f9 = 0.0f;
                        if (f8 >= 0.0f) {
                            f10 = 0.0f;
                            f = f6;
                        } else if (-f8 >= f4) {
                            f10 = 1.0f;
                            f = f4 + 2.0f * f8 + f6;
                        } else {
                            f10 = -f8 / f4;
                            f = f8 * f10 + f6;
                        }
                    }
                }
            } else if (f5 < 0.0f) {
                f10 = 0.0f;
                if (-f5 >= f2) {
                    f9 = 1.0f;
                    f = f2 + 2.0f * f5 + f6;
                } else {
                    f9 = -f5 / f2;
                    f = f5 * f9 + f6;
                }
            } else {
                f9 = 0.0f;
                if (f8 >= 0.0f) {
                    f10 = 0.0f;
                    f = f6;
                } else if (-f8 >= f4) {
                    f10 = 1.0f;
                    f = f4 + 2.0f * f8 + f6;
                } else {
                    f10 = -f8 / f4;
                    f = f8 * f10 + f6;
                }
            }
        } else if (f3 > 0.0f) {
            if (f5 >= 0.0f) {
                float f17 = 0.0f;
                float f18 = 0.0f;
                f = f6;
            } else if (-f5 <= f2) {
                float f19 = -f5 / f2;
                float f20 = 0.0f;
                f = f5 * f19 + f6;
            } else {
                float f21 = -vector.dot(line2.getDirection());
                float f22 = 1.0f;
                float f23 = f2 + f5;
                if (-f23 >= f3) {
                    float f24 = 1.0f;
                    f = f2 + f4 + f6 + 2.0f * (f3 + f5 + f21);
                } else {
                    float f25 = -f23 / f3;
                    f = f2 + 2.0f * f5 + f6 + f25 * (f4 * f25 + 2.0f * (f3 + f21));
                }
            }
        } else if (-f5 >= f2) {
            float f26 = 1.0f;
            float f27 = 0.0f;
            f = f2 + 2.0f * f5 + f6;
        } else if (f5 <= 0.0f) {
            float f28 = -f5 / f2;
            float f29 = 0.0f;
            f = f5 * f28 + f6;
        } else {
            float f30 = -vector.dot(line2.getDirection());
            float f31 = 0.0f;
            if (f5 >= -f3) {
                float f32 = 1.0f;
                f = f4 + 2.0f * f30 + f6;
            } else {
                float f33 = -f5 / f3;
                f = f6 + f33 * (2.0f * f30 + f4 * f33);
            }
        }
        return Math.abs(f);
    }
}

