/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.feature;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.feature.Sky;
import jme.math.Vector;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;

public class SkyBox
implements Sky {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int FRONT = 4;
    public static final int BACK = 5;
    private Vector center = new Vector();
    private float size;
    private int[] textures = new int[6];
    private Vector color;

    public SkyBox(float f) {
        this.size = f / 2.0f;
        this.center = new Vector(this.size, 32.0f, this.size);
        this.color = new Vector(1.0f, 1.0f, 1.0f);
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created SkyBox");
    }

    public void setTexture(int n, String string) {
        if (n < 0 || n > 5) {
            throw new MonkeyRuntimeException("Invalid side.");
        }
        this.textures[n] = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
    }

    public void setTextures(String[] stringArray) {
        if (null == stringArray || stringArray.length != 6) {
            throw new MonkeyRuntimeException("Texture array cannot be null and must be of length 6.");
        }
        for (int i = 0; i < 6; ++i) {
            this.textures[i] = TextureManager.getTextureManager().loadTexture(stringArray[i], 9987, 9729, true);
        }
    }

    public float getSize() {
        return this.size;
    }

    public void setColor(Vector vector) {
        if (null == vector) {
            throw new MonkeyRuntimeException("Color cannot be null.");
        }
        this.color = vector;
    }

    public void update(float f) {
    }

    public void render() {
        GL.glColor4f((float)this.color.x, (float)this.color.y, (float)this.color.z, (float)1.0f);
        GL.glEnable((int)3553);
        GL.glDisable((int)2929);
        GL.glPushMatrix();
        GL.glTranslatef((float)this.center.x, (float)this.center.y, (float)this.center.z);
        TextureManager.getTextureManager().bind(this.textures[4]);
        GL.glBegin((int)6);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.size, (float)this.size, (float)this.size);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.size, (float)(-this.size), (float)this.size);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)(-this.size), (float)(-this.size), (float)this.size);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)(-this.size), (float)this.size, (float)this.size);
        GL.glEnd();
        TextureManager.getTextureManager().bind(this.textures[5]);
        GL.glBegin((int)6);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)(-this.size), (float)this.size, (float)(-this.size));
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)(-this.size), (float)(-this.size), (float)(-this.size));
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.size, (float)(-this.size), (float)(-this.size));
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.size, (float)this.size, (float)(-this.size));
        GL.glEnd();
        TextureManager.getTextureManager().bind(this.textures[3]);
        GL.glBegin((int)6);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.size, (float)this.size, (float)(-this.size));
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.size, (float)(-this.size), (float)(-this.size));
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.size, (float)(-this.size), (float)this.size);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.size, (float)this.size, (float)this.size);
        GL.glEnd();
        TextureManager.getTextureManager().bind(this.textures[2]);
        GL.glBegin((int)6);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)(-this.size), (float)this.size, (float)this.size);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)(-this.size), (float)(-this.size), (float)this.size);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)(-this.size), (float)(-this.size), (float)(-this.size));
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)(-this.size), (float)this.size, (float)(-this.size));
        GL.glEnd();
        TextureManager.getTextureManager().bind(this.textures[0]);
        GL.glBegin((int)6);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)(-this.size), (float)this.size, (float)this.size);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)(-this.size), (float)this.size, (float)(-this.size));
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.size, (float)this.size, (float)(-this.size));
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.size, (float)this.size, (float)this.size);
        GL.glEnd();
        TextureManager.getTextureManager().bind(this.textures[1]);
        GL.glBegin((int)6);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)(-this.size), (float)(-this.size), (float)(-this.size));
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)(-this.size), (float)(-this.size), (float)this.size);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.size, (float)(-this.size), (float)this.size);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.size, (float)(-this.size), (float)(-this.size));
        GL.glEnd();
        GL.glPopMatrix();
        GL.glEnable((int)2929);
    }
}

