/*
 * Decompiled with CFR 0.152.
 */
package jme.locale;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.locale.Locale;
import jme.math.Vector;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;

public class SimpleLocale
implements Locale {
    private Vector center;
    private float halfLength;
    private int textureID;
    private float red = 1.0f;
    private float blue = 1.0f;
    private float green = 1.0f;
    private float alpha = 1.0f;

    public SimpleLocale(Vector vector, float f) {
        if (null == vector || f <= 0.0f) {
            throw new MonkeyRuntimeException("Center must be defined, and length must be greater than 0.");
        }
        this.center = vector;
        this.halfLength = f / 2.0f;
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "SimpleLocale created.");
    }

    public void update(float f) {
    }

    public void render() {
        if (this.textureID > 0) {
            GL.glEnable((int)3553);
            TextureManager.getTextureManager().bind(this.textureID);
        }
        GL.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        GL.glBegin((int)7);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)(this.center.x - this.halfLength), (float)this.center.y, (float)(this.center.z + this.halfLength));
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)(this.center.x + this.halfLength), (float)this.center.y, (float)(this.center.z + this.halfLength));
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)(this.center.x + this.halfLength), (float)this.center.y, (float)(this.center.z - this.halfLength));
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)(this.center.x - this.halfLength), (float)this.center.y, (float)(this.center.z - this.halfLength));
        GL.glEnd();
        if (this.textureID > 0) {
            GL.glDisable((int)3553);
        }
    }

    public void setTexture(String string) {
        this.textureID = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
        this.alpha = f4;
    }

    public Vector getCenter() {
        return this.center;
    }

    public float getLength() {
        return this.halfLength * 2.0f;
    }

    public void setCenter(Vector vector) {
        this.center = vector;
    }

    public void setLength(float f) {
        this.halfLength = f / 2.0f;
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nCenter: " + this.center.toString();
        string = string + "\nSide Length: " + this.halfLength * 2.0f;
        string = string + "\nColor: " + this.red + " " + this.green + " " + this.blue + " " + this.alpha;
        string = string + "\nTexture Name: " + this.textureID;
        return string;
    }

    public boolean useDistanceFog() {
        return false;
    }

    public boolean useVolumetricFog() {
        return false;
    }
}

