/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.primitive;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.primitive.Quadric;
import jme.math.Vector;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GLU;

public class Cylinder
extends Quadric {
    private double baseRadius;
    private double topRadius;
    private double height;
    private int slices;
    private int stacks;
    private GLU glu;

    public Cylinder(double d, double d2, double d3, int n, int n2) {
        if (d <= 0.0 || d3 <= 0.0 || n <= 0 || n2 <= 0 || d2 < 0.0) {
            throw new MonkeyRuntimeException("No parameter may be less than zero, and only toRadius may be zero");
        }
        this.baseRadius = d;
        this.topRadius = d2;
        this.height = d3;
        this.slices = n;
        this.stacks = n2;
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Cylinder created.");
    }

    public void render() {
        super.preRender();
        super.clean();
    }

    public void setBaseRadius(double d) {
        if (d <= 0.0) {
            throw new MonkeyRuntimeException("baseRadius must be greater than zero");
        }
        this.baseRadius = d;
    }

    public void setTopRadius(double d) {
        if (d < 0.0) {
            throw new MonkeyRuntimeException("topRadius must be greater than or equal to zero");
        }
        this.topRadius = d;
    }

    public void setHeight(double d) {
        if (d <= 0.0) {
            throw new MonkeyRuntimeException("Height must be greater than zero");
        }
        this.height = d;
    }

    public void setSlices(int n) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("slices must be greater than zero");
        }
        this.slices = n;
    }

    public void setStacks(int n) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("Stacks must be greater than zero");
        }
        this.stacks = n;
    }

    public Vector[] getPoints() {
        return null;
    }
}

