/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.primitive;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.primitive.Primitive;
import jme.math.Vector;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;

public class Box
extends Primitive {
    private GL gl;
    private Vector[] corners;

    public Box() {
        this.corners = new Vector[8];
        for (int i = 0; i < 8; ++i) {
            this.corners[i] = new Vector();
        }
        this.initialize();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Box created.");
    }

    public Box(Vector[] vectorArray) {
        if (null == vectorArray) {
            throw new MonkeyRuntimeException("Corners cannot be null.");
        }
        this.corners = vectorArray;
        this.initialize();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Box created.");
    }

    public Box(float f) {
        this.corners = new Vector[8];
        this.corners[0] = new Vector(-f / 2.0f, f / 2.0f, -f / 2.0f);
        this.corners[1] = new Vector(f / 2.0f, f / 2.0f, -f / 2.0f);
        this.corners[2] = new Vector(-f / 2.0f, -f / 2.0f, -f / 2.0f);
        this.corners[3] = new Vector(f / 2.0f, -f / 2.0f, -f / 2.0f);
        this.corners[4] = new Vector(-f / 2.0f, f / 2.0f, f / 2.0f);
        this.corners[5] = new Vector(f / 2.0f, f / 2.0f, f / 2.0f);
        this.corners[6] = new Vector(-f / 2.0f, -f / 2.0f, f / 2.0f);
        this.corners[7] = new Vector(f / 2.0f, -f / 2.0f, f / 2.0f);
        this.initialize();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Box created.");
    }

    public void render() {
        if (this.getTextureId() > 0) {
            TextureManager.getTextureManager().bind(this.getTextureId());
            GL.glEnable((int)3553);
        }
        GL.glBegin((int)7);
        GL.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[0].x, (float)this.corners[0].y, (float)this.corners[0].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[1].x, (float)this.corners[1].y, (float)this.corners[1].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[3].x, (float)this.corners[3].y, (float)this.corners[3].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[2].x, (float)this.corners[2].y, (float)this.corners[2].z);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[5].x, (float)this.corners[5].y, (float)this.corners[5].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[4].x, (float)this.corners[4].y, (float)this.corners[4].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[6].x, (float)this.corners[6].y, (float)this.corners[6].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[7].x, (float)this.corners[7].y, (float)this.corners[7].z);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[4].x, (float)this.corners[4].y, (float)this.corners[4].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[5].x, (float)this.corners[5].y, (float)this.corners[5].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[1].x, (float)this.corners[1].y, (float)this.corners[1].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[0].x, (float)this.corners[0].y, (float)this.corners[0].z);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[6].x, (float)this.corners[6].y, (float)this.corners[6].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[2].x, (float)this.corners[2].y, (float)this.corners[2].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[3].x, (float)this.corners[3].y, (float)this.corners[3].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[7].x, (float)this.corners[7].y, (float)this.corners[7].z);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[4].x, (float)this.corners[4].y, (float)this.corners[4].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[0].x, (float)this.corners[0].y, (float)this.corners[0].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[2].x, (float)this.corners[2].y, (float)this.corners[2].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[6].x, (float)this.corners[6].y, (float)this.corners[6].z);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[1].x, (float)this.corners[1].y, (float)this.corners[1].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.corners[5].x, (float)this.corners[5].y, (float)this.corners[5].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[7].x, (float)this.corners[7].y, (float)this.corners[7].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.corners[3].x, (float)this.corners[3].y, (float)this.corners[3].z);
        GL.glEnd();
        if (this.getTextureId() > 0) {
            GL.glDisable((int)3553);
        }
    }

    public void initialize() {
        float f = 0.0f;
        for (int i = 0; i < 8; ++i) {
            float f2 = (float)Math.sqrt(this.corners[i].x * this.corners[i].x + this.corners[i].y * this.corners[i].y + this.corners[i].z * this.corners[i].z);
            if (!(f2 > f)) continue;
            f = f2;
        }
    }

    public void preRender() {
    }

    public void setCorners(Vector[] vectorArray) {
        if (null == vectorArray) {
            throw new MonkeyRuntimeException("Corners cannot be null.");
        }
        this.corners = vectorArray;
        this.initialize();
    }

    public void setCorner(int n, Vector vector) {
        this.corners[n] = vector;
        this.initialize();
    }

    public Vector[] getPoints() {
        return this.corners;
    }
}

