/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.model.md3;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import jme.exception.MonkeyGLException;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.Geometry;
import jme.math.Quaternion;
import jme.math.Vector;
import jme.system.DisplaySystem;
import jme.texture.TextureManager;
import jme.utility.Conversion;
import jme.utility.LoggingSystem;
import jme.utility.StringUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.Window;

public class Md3Model
implements Geometry {
    public static final int LOWER = 0;
    public static final int UPPER = 1;
    public static final int HEAD = 2;
    public static final int WEAPON = 3;
    private ByteBuffer buffer;
    private byte[] fileContents;
    private Md3Header header;
    private Md3Skin[] skins;
    private Md3TexCoord[] texCoords;
    private Md3Triangle[] triangles;
    private Md3Triangle[] vertices;
    private Md3Bone[] bones;
    private String path;
    private String model;
    private String weapon;
    private Model3D head;
    private Model3D upper;
    private Model3D lower;
    private Model3D weaponModel;
    private FloatBuffer buf;
    private Vector scale;
    private float r;
    private float g;
    private float b;
    private float a;
    private ArrayList points;
    private static final int START_TORSO_ANIMATION = 6;
    private static final int START_LEGS_ANIMATION = 13;
    private static final int MAX_ANIMATIONS = 25;

    public Md3Model(String string, String string2, String string3) {
        if (null == string || null == string2) {
            throw new MonkeyRuntimeException("Path and model cannot be null.");
        }
        if (!Window.isCreated()) {
            throw new MonkeyGLException("Window must be created first.");
        }
        this.buf = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.scale = new Vector(1.0f, 1.0f, 1.0f);
        this.r = 1.0f;
        this.g = 1.0f;
        this.b = 1.0f;
        this.a = 1.0f;
        this.path = string;
        this.model = string2;
        this.weapon = string3;
        this.head = new Model3D();
        this.upper = new Model3D();
        this.lower = new Model3D();
        this.weaponModel = new Model3D();
        this.points = new ArrayList();
        this.initialize();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Successfully loaded MD3 model " + string2);
    }

    public void setModelString(String string) {
        this.model = string;
    }

    public void setWeaponString(String string) {
        this.weapon = string;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public Model3D getModel(int n) {
        if (n == 0) {
            return this.lower;
        }
        if (n == 1) {
            return this.upper;
        }
        if (n == 2) {
            return this.head;
        }
        return this.weaponModel;
    }

    public void initialize() {
        this.loadModel();
        this.loadWeapon();
    }

    public void render() {
        DisplaySystem.getDisplaySystem().cullMode(1028, true);
        GL.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
        GL.glColor4f((float)this.r, (float)this.g, (float)this.b, (float)this.a);
        this.updateModel(this.lower);
        this.updateModel(this.upper);
        this.drawLink(this.lower);
        DisplaySystem.getDisplaySystem().cullMode(1029, true);
    }

    public void setTorsoAnimation(String string) {
        for (int i = 0; i < this.upper.numOfAnimations; ++i) {
            if (!((AnimationInfo)this.upper.animations.get((int)i)).name.equals(string)) continue;
            this.upper.currentAnim = i;
            this.upper.currentFrame = ((AnimationInfo)this.upper.animations.get((int)this.upper.currentAnim)).startFrame;
            return;
        }
    }

    public void setLegsAnimation(String string) {
        for (int i = 0; i < this.lower.numOfAnimations; ++i) {
            if (!((AnimationInfo)this.lower.animations.get((int)i)).name.equals(string)) continue;
            this.lower.currentAnim = i;
            this.lower.currentFrame = ((AnimationInfo)this.lower.animations.get((int)this.lower.currentAnim)).startFrame;
            return;
        }
    }

    public void setTexture(String string) {
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
    }

    public void setScale(Vector vector) {
        this.scale = vector;
    }

    public Vector[] getPoints() {
        Vector[] vectorArray = new Vector[this.points.size()];
        return this.points.toArray(vectorArray);
    }

    public boolean loadModel() {
        if (null == this.path || null == this.model) {
            return false;
        }
        String string = this.path + "/" + this.model + "_lower.md3";
        String string2 = this.path + "/" + this.model + "_upper.md3";
        String string3 = this.path + "/" + this.model + "_head.md3";
        String string4 = this.path + "/" + this.model + "_lower.skin";
        String string5 = this.path + "/" + this.model + "_upper.skin";
        String string6 = this.path + "/" + this.model + "_head.skin";
        if (!this.importMD3(this.head, string3)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the HEAD model!");
            return false;
        }
        if (!this.importMD3(this.upper, string2)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the UPPER model!");
            return false;
        }
        if (!this.importMD3(this.lower, string)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the LOWER model!");
            return false;
        }
        if (!this.loadSkin(this.lower, string4)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the LOWER skin!");
            return false;
        }
        if (!this.loadSkin(this.upper, string5)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the UPPER skin!");
            return false;
        }
        if (!this.loadSkin(this.head, string6)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the HEAD skin!");
            return false;
        }
        this.loadModelTextures(this.lower, this.path);
        this.loadModelTextures(this.upper, this.path);
        this.loadModelTextures(this.head, this.path);
        String string7 = this.path + "/" + this.model + "_animation.cfg";
        if (!this.loadAnimations(string7)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the Animation Config File!");
            return false;
        }
        this.linkModel(this.lower, this.upper, "tag_torso");
        this.linkModel(this.upper, this.head, "tag_head");
        return true;
    }

    public boolean loadWeapon() {
        if (null == this.path || null == this.weapon) {
            return false;
        }
        String string = this.path + "/" + this.weapon + ".md3";
        if (!this.importMD3(this.weaponModel, string)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the WEAPON model!");
            return false;
        }
        String string2 = this.path + "/" + this.weapon + ".shader";
        if (!this.loadShader(this.weaponModel, string2)) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load the SHADER file!");
            return false;
        }
        this.loadModelTextures(this.weaponModel, this.path);
        this.linkModel(this.upper, this.weaponModel, "tag_weapon");
        return true;
    }

    private boolean importMD3(Model3D model3D, String string) {
        Object object;
        System.out.println("LOADING: " + string);
        int n = 0;
        File file = new File(string);
        try {
            object = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            n = (int)file.length();
            this.fileContents = new byte[n];
            System.out.println(this.fileContents.length);
            bufferedInputStream.read(this.fileContents, 0, n);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new MonkeyRuntimeException("Could not open MD3 Model." + string);
        }
        this.buffer = ByteBuffer.wrap(this.fileContents).order(ByteOrder.nativeOrder());
        this.header = new Md3Header();
        object = new byte[4];
        for (int i = 0; i < 4; ++i) {
            object[i] = this.buffer.get();
        }
        this.header.fileID = Conversion.byte2String((byte[])object);
        this.header.version = this.buffer.getInt();
        byte[] byArray = new byte[68];
        for (int i = 0; i < 68; ++i) {
            byArray[i] = this.buffer.get();
        }
        this.header.file = Conversion.byte2String(byArray);
        this.header.numFrames = this.buffer.getInt();
        this.header.numTags = this.buffer.getInt();
        this.header.numMeshes = this.buffer.getInt();
        this.header.numMaxSkins = this.buffer.getInt();
        this.header.headerSize = this.buffer.getInt();
        this.header.tagStart = this.buffer.getInt();
        this.header.tagEnd = this.buffer.getInt();
        this.header.fileSize = this.buffer.getInt();
        String string2 = this.header.fileID;
        if (!string2.equals("IDP3") || this.header.version != 15) {
            System.err.println("Invalid file format (Version not 15): " + string + "!");
            return false;
        }
        this.readMD3Data(model3D);
        return true;
    }

    private void readMD3Data(Model3D model3D) {
        int n;
        byte[] byArray;
        int n2 = 0;
        this.bones = new Md3Bone[this.header.numFrames];
        for (n2 = 0; n2 < this.header.numFrames; ++n2) {
            this.bones[n2] = new Md3Bone();
            this.bones[n2].mins[0] = this.buffer.getFloat();
            this.bones[n2].mins[1] = this.buffer.getFloat();
            this.bones[n2].mins[2] = this.buffer.getFloat();
            this.bones[n2].maxs[0] = this.buffer.getFloat();
            this.bones[n2].maxs[1] = this.buffer.getFloat();
            this.bones[n2].maxs[2] = this.buffer.getFloat();
            this.bones[n2].position[0] = this.buffer.getFloat();
            this.bones[n2].position[1] = this.buffer.getFloat();
            this.bones[n2].position[2] = this.buffer.getFloat();
            this.bones[n2].scale = this.buffer.getFloat();
            byArray = new byte[16];
            for (n = 0; n < 16; ++n) {
                byArray[n] = this.buffer.get();
            }
            this.bones[n2].creator = Conversion.byte2String(byArray);
        }
        this.bones = null;
        model3D.tags = new Md3Tag[this.header.numFrames * this.header.numTags];
        for (n2 = 0; n2 < this.header.numFrames * this.header.numTags; ++n2) {
            model3D.tags[n2] = new Md3Tag();
            byArray = new byte[64];
            for (n = 0; n < 64; ++n) {
                byArray[n] = this.buffer.get();
            }
            model3D.tags[n2].name = Conversion.byte2String(byArray);
            model3D.tags[n2].position.x = this.buffer.getFloat();
            model3D.tags[n2].position.y = this.buffer.getFloat();
            model3D.tags[n2].position.z = this.buffer.getFloat();
            for (n = 0; n < 9; ++n) {
                model3D.tags[n2].rotation[n] = this.buffer.getFloat();
            }
        }
        model3D.numOfTags = this.header.numTags;
        model3D.links = new Model3D[this.header.numTags];
        for (n2 = 0; n2 < this.header.numTags; ++n2) {
            model3D.links[n2] = null;
        }
        int n3 = this.buffer.position();
        Md3MeshInfo md3MeshInfo = new Md3MeshInfo();
        for (int i = 0; i < this.header.numMeshes; ++i) {
            this.buffer.position(n3);
            md3MeshInfo = new Md3MeshInfo();
            byte[] byArray2 = new byte[4];
            for (int j = 0; j < 4; ++j) {
                byArray2[j] = this.buffer.get();
            }
            md3MeshInfo.meshID = Conversion.byte2String(byArray2);
            byte[] byArray3 = new byte[68];
            for (int j = 0; j < 68; ++j) {
                byArray3[j] = this.buffer.get();
            }
            md3MeshInfo.name = Conversion.byte2String(byArray3);
            md3MeshInfo.numMeshFrames = this.buffer.getInt();
            md3MeshInfo.numSkins = this.buffer.getInt();
            md3MeshInfo.numVertices = this.buffer.getInt();
            md3MeshInfo.numTriangles = this.buffer.getInt();
            md3MeshInfo.triStart = this.buffer.getInt();
            md3MeshInfo.headerSize = this.buffer.getInt();
            md3MeshInfo.uvStart = this.buffer.getInt();
            md3MeshInfo.vertexStart = this.buffer.getInt();
            md3MeshInfo.meshSize = this.buffer.getInt();
            this.skins = new Md3Skin[md3MeshInfo.numSkins];
            this.texCoords = new Md3TexCoord[md3MeshInfo.numVertices];
            this.triangles = new Md3Triangle[md3MeshInfo.numTriangles];
            this.vertices = new Md3Triangle[md3MeshInfo.numVertices * md3MeshInfo.numMeshFrames];
            for (n2 = 0; n2 < md3MeshInfo.numSkins; ++n2) {
                this.skins[n2] = new Md3Skin();
                byte[] byArray4 = new byte[68];
                for (int j = 0; j < 68; ++j) {
                    byArray4[j] = this.buffer.get();
                }
                this.skins[n2].name = Conversion.byte2String(byArray4);
            }
            this.buffer.position(n3 + md3MeshInfo.triStart);
            for (n2 = 0; n2 < md3MeshInfo.numTriangles; ++n2) {
                this.triangles[n2] = new Md3Triangle();
                this.triangles[n2].vertexIndices[0] = this.buffer.getInt();
                this.triangles[n2].vertexIndices[1] = this.buffer.getInt();
                this.triangles[n2].vertexIndices[2] = this.buffer.getInt();
            }
            this.buffer.position(n3 + md3MeshInfo.uvStart);
            for (n2 = 0; n2 < md3MeshInfo.numVertices; ++n2) {
                this.texCoords[n2] = new Md3TexCoord();
                this.texCoords[n2].textureCoord[0] = this.buffer.getFloat();
                this.texCoords[n2].textureCoord[1] = this.buffer.getFloat();
            }
            this.buffer.position(n3 + md3MeshInfo.vertexStart);
            for (n2 = 0; n2 < md3MeshInfo.numMeshFrames * md3MeshInfo.numVertices; ++n2) {
                this.vertices[n2] = new Md3Triangle();
                this.vertices[n2].vertex[0] = this.buffer.getShort();
                this.vertices[n2].vertex[1] = this.buffer.getShort();
                this.vertices[n2].vertex[2] = this.buffer.getShort();
                this.points.add(new Vector(this.vertices[n2].vertex[0], this.vertices[n2].vertex[1], this.vertices[n2].vertex[2]));
                this.vertices[n2].normal[0] = this.buffer.get();
                this.vertices[n2].normal[1] = this.buffer.get();
            }
            this.convertDataStructures(model3D, md3MeshInfo);
            this.skins = null;
            this.texCoords = null;
            this.triangles = null;
            this.vertices = null;
            n3 += md3MeshInfo.meshSize;
        }
    }

    private void convertDataStructures(Model3D model3D, Md3MeshInfo md3MeshInfo) {
        int n = 0;
        ++model3D.numOfObjects;
        Object3D object3D = new Object3D();
        object3D.name = md3MeshInfo.name;
        object3D.numOfVerts = md3MeshInfo.numVertices;
        object3D.numTexVertex = md3MeshInfo.numVertices;
        object3D.numOfFaces = md3MeshInfo.numTriangles;
        object3D.verts = new Vector[object3D.numOfVerts * md3MeshInfo.numMeshFrames];
        object3D.texVerts = new Vector[object3D.numOfVerts];
        object3D.faces = new Face[object3D.numOfFaces];
        for (n = 0; n < object3D.numOfVerts * md3MeshInfo.numMeshFrames; ++n) {
            object3D.verts[n] = new Vector();
            object3D.verts[n].x = (float)this.vertices[n].vertex[0] / 64.0f;
            object3D.verts[n].y = (float)this.vertices[n].vertex[1] / 64.0f;
            object3D.verts[n].z = (float)this.vertices[n].vertex[2] / 64.0f;
        }
        for (n = 0; n < object3D.numTexVertex; ++n) {
            object3D.texVerts[n] = new Vector();
            object3D.texVerts[n].x = this.texCoords[n].textureCoord[0];
            object3D.texVerts[n].y = -this.texCoords[n].textureCoord[1];
        }
        for (n = 0; n < object3D.numOfFaces; ++n) {
            object3D.faces[n] = new Face();
            object3D.faces[n].vertIndex[0] = this.triangles[n].vertexIndices[0];
            object3D.faces[n].vertIndex[1] = this.triangles[n].vertexIndices[1];
            object3D.faces[n].vertIndex[2] = this.triangles[n].vertexIndices[2];
            object3D.faces[n].coordIndex[0] = this.triangles[n].vertexIndices[0];
            object3D.faces[n].coordIndex[1] = this.triangles[n].vertexIndices[1];
            object3D.faces[n].coordIndex[2] = this.triangles[n].vertexIndices[2];
        }
        model3D.object.add(object3D);
    }

    private boolean loadSkin(Model3D model3D, String string) {
        System.out.println(string);
        if (model3D == null || string == null) {
            return false;
        }
        FileInputStream fileInputStream = null;
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                for (int i = 0; i < model3D.numOfObjects; ++i) {
                    if (!StringUtils.isInString(string2, ((Object3D)model3D.object.get((int)i)).name)) continue;
                    n = string2.lastIndexOf("/") + 1;
                    MaterialInfo materialInfo = new MaterialInfo();
                    materialInfo.file = string2.substring(n);
                    materialInfo.uTile = 1.0f;
                    materialInfo.uTile = 1.0f;
                    ((Object3D)model3D.object.get((int)i)).materialID = model3D.numOfMaterials++;
                    ((Object3D)model3D.object.get((int)i)).hasTexture = true;
                    model3D.materials.add(materialInfo);
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new MonkeyRuntimeException("Could not load skin.");
        }
        return true;
    }

    private boolean loadShader(Model3D model3D, String string) {
        if (null == model3D || null == string) {
            return false;
        }
        FileInputStream fileInputStream = null;
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                MaterialInfo materialInfo = new MaterialInfo();
                materialInfo.file = string2;
                materialInfo.vTile = 1.0f;
                materialInfo.uTile = 1.0f;
                ((Object3D)model3D.object.get((int)n)).materialID = model3D.numOfMaterials++;
                ((Object3D)model3D.object.get((int)n)).hasTexture = true;
                model3D.materials.add(materialInfo);
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new MonkeyRuntimeException("Could not load shader " + string);
        }
        return true;
    }

    private void loadModelTextures(Model3D model3D, String string) {
        for (int i = 0; i < model3D.numOfMaterials; ++i) {
            if (((MaterialInfo)model3D.materials.get((int)i)).file == null) continue;
            String string2 = string + "/" + ((MaterialInfo)model3D.materials.get((int)i)).file;
            ((MaterialInfo)model3D.materials.get((int)i)).texureId = TextureManager.getTextureManager().loadTexture(string2, 9987, 9729, true);
        }
    }

    private boolean loadAnimations(String string) {
        AnimationInfo[] animationInfoArray = new AnimationInfo[25];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = "";
            int n = 0;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0 || !Character.isDigit(string2.charAt(0))) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                int n6 = Integer.parseInt(stringTokenizer.nextToken());
                animationInfoArray[n] = new AnimationInfo();
                animationInfoArray[n].startFrame = n3;
                animationInfoArray[n].endFrame = n3 + n4;
                animationInfoArray[n].loopingFrames = n5;
                animationInfoArray[n].framesPerSecond = n6;
                stringTokenizer.nextToken();
                animationInfoArray[n].name = stringTokenizer.nextToken();
                if (StringUtils.isInString(string2, "BOTH")) {
                    this.upper.animations.add(animationInfoArray[n]);
                    this.lower.animations.add(animationInfoArray[n]);
                } else if (StringUtils.isInString(string2, "TORSO")) {
                    this.upper.animations.add(animationInfoArray[n]);
                } else if (StringUtils.isInString(string2, "LEGS")) {
                    if (n2 == 0) {
                        n2 = animationInfoArray[13].startFrame - animationInfoArray[6].startFrame;
                    }
                    animationInfoArray[n].startFrame -= n2;
                    animationInfoArray[n].endFrame -= n2;
                    this.lower.animations.add(animationInfoArray[n]);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new MonkeyRuntimeException("Could not load animations.");
        }
        this.lower.numOfAnimations = this.lower.animations.size();
        this.upper.numOfAnimations = this.upper.animations.size();
        this.head.numOfAnimations = this.head.animations.size();
        this.weaponModel.numOfAnimations = this.head.animations.size();
        return true;
    }

    private void linkModel(Model3D model3D, Model3D model3D2, String string) {
        if (null == model3D || null == model3D2 || null == string) {
            return;
        }
        for (int i = 0; i < model3D.numOfTags; ++i) {
            if (!model3D.tags[i].name.equals(string)) continue;
            model3D.links[i] = model3D2;
            return;
        }
    }

    private void updateModel(Model3D model3D) {
        int n = 0;
        int n2 = 1;
        AnimationInfo animationInfo = (AnimationInfo)model3D.animations.get(model3D.currentAnim);
        if (model3D.numOfAnimations != 0) {
            n = animationInfo.startFrame;
            n2 = animationInfo.endFrame;
        }
        model3D.nextFrame = (model3D.currentFrame + 1) % n2;
        if (model3D.nextFrame == 0) {
            model3D.nextFrame = n;
        }
        this.setCurrentTime(model3D);
    }

    private void drawLink(Model3D model3D) {
        this.renderModel(model3D);
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion();
        Quaternion quaternion3 = new Quaternion();
        float[] fArray = new float[16];
        for (int i = 0; i < model3D.numOfTags; ++i) {
            if (model3D.links[i] == null) continue;
            Vector vector = model3D.tags[model3D.currentFrame * model3D.numOfTags + i].position;
            Vector vector2 = model3D.tags[model3D.nextFrame * model3D.numOfTags + i].position;
            Vector vector3 = new Vector();
            vector3.x = vector.x + model3D.t * (vector2.x - vector.x);
            vector3.y = vector.y + model3D.t * (vector2.y - vector.y);
            vector3.z = vector.z + model3D.t * (vector2.z - vector.z);
            float[] fArray2 = model3D.tags[model3D.currentFrame * model3D.numOfTags + i].rotation;
            float[] fArray3 = model3D.tags[model3D.nextFrame * model3D.numOfTags + i].rotation;
            quaternion.fromMatrix(fArray2, 3);
            quaternion2.fromMatrix(fArray3, 3);
            quaternion3 = quaternion.slerp(quaternion, quaternion2, model3D.t);
            fArray = quaternion3.toMatrix();
            fArray[12] = vector3.x;
            fArray[13] = vector3.y;
            fArray[14] = vector3.z;
            GL.glPushMatrix();
            this.buf.clear();
            this.buf.put(fArray);
            this.buf.flip();
            GL.glMultMatrixf((FloatBuffer)this.buf);
            this.drawLink(model3D.links[i]);
            GL.glPopMatrix();
        }
    }

    private void setCurrentTime(Model3D model3D) {
        if (model3D.animations.size() == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - model3D.lastTime;
        int n = ((AnimationInfo)model3D.animations.get((int)model3D.currentAnim)).framesPerSecond;
        float f = (float)l2 / (1000.0f / (float)n);
        if ((float)l2 >= 1000.0f / (float)n) {
            model3D.currentFrame = model3D.nextFrame;
            model3D.lastTime = l;
        }
        model3D.t = f;
    }

    private void renderModel(Model3D model3D) {
        if (null == model3D.object) {
            return;
        }
        for (int i = 0; i < model3D.numOfObjects; ++i) {
            int n;
            Object3D object3D = (Object3D)model3D.object.get(i);
            int n2 = model3D.currentFrame * object3D.numOfVerts;
            int n3 = model3D.nextFrame * object3D.numOfVerts;
            if (object3D.hasTexture) {
                GL.glEnable((int)3553);
                n = ((MaterialInfo)model3D.materials.get((int)object3D.materialID)).texureId;
                TextureManager.getTextureManager().bind(n);
            } else {
                GL.glDisable((int)3553);
            }
            GL.glBegin((int)4);
            for (n = 0; n < object3D.numOfFaces; ++n) {
                for (int j = 0; j < 3; ++j) {
                    int n4 = object3D.faces[n].vertIndex[j];
                    if (object3D.texVerts != null) {
                        GL.glTexCoord2f((float)object3D.texVerts[n4].x, (float)object3D.texVerts[n4].y);
                    }
                    Vector vector = object3D.verts[n2 + n4];
                    Vector vector2 = object3D.verts[n3 + n4];
                    GL.glVertex3f((float)(vector.x + model3D.t * (vector2.x - vector.x)), (float)(vector.y + model3D.t * (vector2.y - vector.y)), (float)(vector.z + model3D.t * (vector2.z - vector.z)));
                }
            }
            GL.glEnd();
        }
    }

    private class Model3D {
        int numOfObjects;
        int numOfMaterials;
        ArrayList materials = new ArrayList();
        ArrayList object = new ArrayList();
        int numOfAnimations;
        int currentAnim;
        int currentFrame;
        int nextFrame;
        float t;
        long lastTime;
        ArrayList animations = new ArrayList();
        int numOfTags;
        Model3D[] links;
        Md3Tag[] tags;

        private Model3D() {
        }
    }

    private class AnimationInfo {
        String name;
        int startFrame;
        int endFrame;
        int loopingFrames;
        int framesPerSecond;

        private AnimationInfo() {
        }
    }

    private class Object3D {
        int numOfVerts;
        int numOfFaces;
        int numTexVertex;
        int materialID;
        boolean hasTexture;
        String name;
        Vector[] verts;
        Vector[] normals;
        Vector[] texVerts;
        Face[] faces;

        private Object3D() {
        }
    }

    private class MaterialInfo {
        String name;
        String file;
        byte[] color = new byte[3];
        int texureId;
        float uTile;
        float vTile;
        float uOffset;
        float vOffset;

        private MaterialInfo() {
        }
    }

    private class Face {
        int[] vertIndex = new int[3];
        int[] coordIndex = new int[3];

        private Face() {
        }
    }

    private class Md3Triangle {
        short[] vertex = new short[3];
        int[] normal = new int[2];
        public int flags;
        public byte smoothingGroup;
        public byte groupIndex;
        public int[] vertexIndices = new int[3];
        public float[][] vertexNormals = new float[3][3];
        public float[] s = new float[3];
        public float[] t = new float[3];

        private Md3Triangle() {
        }
    }

    private class Md3Bone {
        float[] mins = new float[3];
        float[] maxs = new float[3];
        float[] position = new float[3];
        float scale;
        String creator;

        private Md3Bone() {
        }
    }

    private class Md3Tag {
        String name;
        Vector position = new Vector();
        float[] rotation = new float[9];

        private Md3Tag() {
        }
    }

    private class Md3TexCoord {
        float[] textureCoord = new float[2];

        private Md3TexCoord() {
        }
    }

    private class Md3Skin {
        String name;

        private Md3Skin() {
        }
    }

    private class Md3MeshInfo {
        String meshID;
        String name;
        int numMeshFrames;
        int numSkins;
        int numVertices;
        int numTriangles;
        int triStart;
        int headerSize;
        int uvStart;
        int vertexStart;
        int meshSize;

        private Md3MeshInfo() {
        }
    }

    private class Md3Header {
        String fileID;
        int version;
        String file;
        int numFrames;
        int numTags;
        int numMeshes;
        int numMaxSkins;
        int headerSize;
        int tagStart;
        int tagEnd;
        int fileSize;

        private Md3Header() {
        }
    }
}

