/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.bounding;

import jme.entity.camera.Frustum;
import jme.geometry.bounding.BoundingVolume;
import jme.math.Vector;

public class BoundingSphere
implements BoundingVolume {
    private float radius;
    private Vector center;

    public BoundingSphere() {
        this.center = new Vector();
    }

    public BoundingSphere(float f, Vector vector) {
        this.center = null == vector ? new Vector() : vector;
        this.radius = f;
    }

    public float getRadius() {
        return this.radius;
    }

    public Vector getCenter() {
        return this.center;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setCenter(Vector vector) {
        this.center = vector;
    }

    public void containAABB(Vector[] vectorArray) {
        Vector vector;
        Vector vector2 = vector = vectorArray[0];
        for (int i = 1; i < vectorArray.length; ++i) {
            if (vectorArray[i].x < vector.x) {
                vector.x = vectorArray[i].x;
            } else if (vectorArray[i].x > vector2.x) {
                vector2.x = vectorArray[i].x;
            }
            if (vectorArray[i].y < vector.y) {
                vector.y = vectorArray[i].y;
            } else if (vectorArray[i].y > vector2.y) {
                vector2.y = vectorArray[i].y;
            }
            if (vectorArray[i].z < vector.z) {
                vector.z = vectorArray[i].z;
                continue;
            }
            if (!(vectorArray[i].z > vector2.z)) continue;
            vector2.z = vectorArray[i].z;
        }
        this.center = vector2.add(vector);
        this.center = this.center.mult(0.5f);
        Vector vector3 = vector2.subtract(vector);
        vector3 = vector3.mult(0.5f);
        this.radius = vector3.length();
    }

    public void averagePoints(Vector[] vectorArray) {
        this.center = vectorArray[0];
        for (int i = 1; i < vectorArray.length; ++i) {
            this.center = this.center.add(vectorArray[i]);
        }
        float f = 1.0f / (float)vectorArray.length;
        this.center = this.center.mult(f);
        float f2 = 0.0f;
        for (int i = 0; i < vectorArray.length; ++i) {
            Vector vector = vectorArray[i].subtract(this.center);
            float f3 = vector.lengthSquared();
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        this.radius = (float)Math.sqrt(f2);
    }

    public boolean hasCollision(BoundingVolume boundingVolume) {
        return false;
    }

    public float distance(BoundingVolume boundingVolume) {
        return -1.0f;
    }

    public boolean isVisible(Frustum frustum) {
        return true;
    }
}

