/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.bounding;

import jme.entity.camera.Frustum;
import jme.geometry.bounding.BoundingVolume;
import jme.math.Approximation;
import jme.math.Distance;
import jme.math.Line;
import jme.math.Vector;

public class BoundingCylinder
implements BoundingVolume {
    private Vector center;
    private Vector direction;
    private Vector u;
    private Vector v;
    private float height;
    private float radius;

    public BoundingCylinder() {
        this.center = new Vector();
        this.direction = new Vector();
        this.u = new Vector();
        this.v = new Vector();
    }

    public BoundingCylinder(Vector vector, Vector vector2, Vector vector3, Vector vector4, float f, float f2) {
        this.center = vector;
        this.direction = vector2;
        this.u = vector3;
        this.v = vector4;
        this.height = f;
        this.radius = f2;
    }

    public void generateCoordinateSystem() {
        Vector.generateOrthonormalBasis(this.u, this.v, this.direction, true);
    }

    public void leastSquaresFit(Vector[] vectorArray) {
        float f;
        Line line = Approximation.orthogonalLineFit(vectorArray);
        float f2 = 0.0f;
        for (int i = 0; i < vectorArray.length; ++i) {
            f = Distance.distancePointLineSquared(vectorArray[i], line);
            if (!(f > f2)) continue;
            f2 = f;
        }
        Vector vector = vectorArray[0].subtract(line.getOrigin());
        float f3 = f = line.getDirection().dot(vector);
        for (int i = 1; i < vectorArray.length; ++i) {
            vector = vectorArray[i].subtract(line.getOrigin());
            float f4 = line.getDirection().dot(vector);
            if (f4 < f) {
                f = f4;
                continue;
            }
            if (!(f4 > f3)) continue;
            f3 = f4;
        }
        this.center = line.getOrigin().add(line.getDirection().mult(0.5f * (f3 + f)));
        this.direction = line.getDirection();
        this.radius = (float)Math.sqrt(f2);
        this.height = f3 - f;
    }

    public boolean hasCollision(BoundingVolume boundingVolume) {
        return false;
    }

    public float distance(BoundingVolume boundingVolume) {
        return -1.0f;
    }

    public boolean isVisible(Frustum frustum) {
        return true;
    }
}

