/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.bounding;

import jme.entity.camera.Frustum;
import jme.geometry.bounding.BoundingVolume;
import jme.math.Vector;

public class BoundingBox
implements BoundingVolume {
    private Vector center;
    private Vector minPoint;
    private Vector maxPoint;

    public BoundingBox() {
        this.center = new Vector();
        this.minPoint = new Vector();
        this.maxPoint = new Vector();
    }

    public BoundingBox(Vector vector, Vector vector2, Vector vector3) {
        if (null == vector) {
            vector = new Vector();
        } else {
            this.center = vector;
        }
        this.minPoint = null == vector2 ? new Vector() : vector2;
        this.maxPoint = null == vector3 ? new Vector() : vector3;
    }

    public void axisAligned(Vector[] vectorArray) {
        this.maxPoint = this.minPoint = vectorArray[0];
        for (int i = 1; i < vectorArray.length; ++i) {
            if (vectorArray[i].x < this.minPoint.x) {
                this.minPoint.x = vectorArray[i].x;
            } else if (vectorArray[i].x > this.maxPoint.x) {
                this.maxPoint.x = vectorArray[i].x;
            }
            if (vectorArray[i].y < this.minPoint.y) {
                this.minPoint.y = vectorArray[i].y;
            } else if (vectorArray[i].y > this.maxPoint.y) {
                this.maxPoint.y = vectorArray[i].y;
            }
            if (vectorArray[i].z < this.minPoint.z) {
                this.minPoint.z = vectorArray[i].z;
                continue;
            }
            if (!(vectorArray[i].z > this.maxPoint.z)) continue;
            this.maxPoint.z = vectorArray[i].z;
        }
    }

    public Vector getMinPoint() {
        return this.minPoint;
    }

    public void setMinPoint(Vector vector) {
        this.minPoint = vector;
    }

    public Vector getCenter() {
        return this.center;
    }

    public void setCenter(Vector vector) {
        this.center = vector;
    }

    public Vector getMaxPoint() {
        return this.maxPoint;
    }

    public void setMaxPoint(Vector vector) {
        this.maxPoint = vector;
    }

    public boolean hasCollision(BoundingVolume boundingVolume) {
        return false;
    }

    public float distance(BoundingVolume boundingVolume) {
        return -1.0f;
    }

    public boolean isVisible(Frustum frustum) {
        return true;
    }
}

