/*
 * Decompiled with CFR 0.152.
 */
package jme.entity.camera;

import jme.entity.Entity;
import jme.entity.camera.Frustum;
import jme.locale.external.feature.Sky;
import jme.math.Vector;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLU;

public class Camera
extends Entity {
    private Frustum frustum;
    private Vector view = null;
    private Vector up = null;
    private Vector strafe = null;
    protected Sky sky;

    public Camera(int n) {
        super(n);
        this.view = new Vector();
        this.up = new Vector();
    }

    public Camera(int n, Entity entity) {
        super(n, entity);
        this.view = new Vector();
        this.up = new Vector();
    }

    public Camera(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        super(n);
        this.setUp(new Vector(f7, f8, f9));
        this.setView(new Vector(f4, f5, f6));
        this.setPosition(new Vector(f, f2, f3));
        this.frustum = new Frustum();
    }

    public Camera(int n, Vector vector, Vector vector2, Vector vector3) {
        super(n);
        this.setPosition(vector);
        this.setView(vector2);
        this.setUp(vector3);
    }

    public void setAttributes(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.setUp(new Vector(f7, f8, f9));
        this.setView(new Vector(f4, f5, f6));
        this.setPosition(new Vector(f, f2, f3));
    }

    public void updateFrustum() {
        this.frustum.update();
    }

    public Frustum getFrustum() {
        return this.frustum;
    }

    public void set(Vector vector, Vector vector2, Vector vector3) {
        this.setPosition(vector);
        this.setView(vector2);
        this.setUp(vector3);
    }

    public void setView(float f, float f2, float f3) {
        this.view = new Vector(f, f2, f3);
    }

    public void setView(Vector vector) {
        this.view = vector;
    }

    public void setUp(float f, float f2, float f3) {
        this.up = new Vector(f, f2, f3);
    }

    public void setUp(Vector vector) {
        this.up = vector;
    }

    public void setStrafe(Vector vector) {
        this.strafe = vector;
    }

    public Vector getStrafe() {
        return this.strafe;
    }

    public Vector getView() {
        return this.view;
    }

    public Vector getUp() {
        return this.up;
    }

    public void setSky(Sky sky) {
        this.sky = sky;
    }

    public void update(float f) {
        if (null != this.sky) {
            this.sky.update(f);
        }
    }

    public void render() {
        GLU.gluLookAt((double)this.getPosition().x, (double)this.getPosition().y, (double)this.getPosition().z, (double)this.getView().x, (double)this.getView().y, (double)this.getView().z, (double)this.getUp().x, (double)this.getUp().y, (double)this.getUp().z);
        if (null != this.sky) {
            GL.glPushMatrix();
            float f = this.getPosition().x - this.sky.getSize() / 2.0f;
            float f2 = this.getPosition().y - this.sky.getSize() * 0.75f;
            float f3 = this.getPosition().z - this.sky.getSize() / 2.0f;
            GL.glTranslatef((float)f, (float)f2, (float)f3);
            this.sky.render();
            GL.glPopMatrix();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((Entity)this.children.get(i)).render();
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nPosition: " + this.getPosition().toString();
        string = string + "\nView: " + this.getView().toString();
        string = string + "\nUp: " + this.getUp().toString();
        return string;
    }
}

